import { CanvasPath, Point } from '../types';
export declare type SvgPathProps = {
    paths: Point[];
    id: string;
    strokeWidth: number;
    strokeColor: string;
    command?: (point: Point, i: number, a: Point[]) => string;
};
/**
 * Generate SVG Path tag from the given points
 */
export declare const SvgPath: ({ paths, id, strokeWidth, strokeColor, command, }: SvgPathProps) => JSX.Element;
export declare const line: (pointA: Point, pointB: Point) => {
    length: number;
    angle: number;
};
export declare const bezierCommand: (point: Point, i: number, a: Point[]) => string;
declare type PathProps = {
    id: string;
    paths: CanvasPath[];
};
declare const Paths: ({ id, paths }: PathProps) => JSX.Element;
export default Paths;
