import * as _zag_js_anatomy from '@zag-js/anatomy';
import * as _zag_js_core from '@zag-js/core';
import { EventObject, Service, Machine } from '@zag-js/core';
import { RequiredBy, CommonProperties, PropTypes, NormalizeProps } from '@zag-js/types';

declare const anatomy: _zag_js_anatomy.AnatomyInstance<"root" | "area" | "control" | "item" | "itemValue" | "itemLabel" | "actionTrigger" | "separator">;

interface Time<T = number> {
    days: T;
    hours: T;
    minutes: T;
    seconds: T;
    milliseconds: T;
}
type TimePart = keyof Time;
type TimerAction = "start" | "pause" | "resume" | "reset";
type ElementIds = Partial<{
    root: string;
    area: string;
}>;
interface TickDetails {
    value: number;
    time: Time;
    formattedTime: Time<string>;
}
interface TimerProps extends CommonProperties {
    /**
     * The ids of the timer parts
     */
    ids?: ElementIds | undefined;
    /**
     * Whether the timer should countdown, decrementing the timer on each tick.
     */
    countdown?: boolean | undefined;
    /**
     * The total duration of the timer in milliseconds.
     */
    startMs?: number | undefined;
    /**
     * The minimum count of the timer in milliseconds.
     */
    targetMs?: number | undefined;
    /**
     * Whether the timer should start automatically
     */
    autoStart?: boolean | undefined;
    /**
     * The interval in milliseconds to update the timer count.
     * @default 1000
     */
    interval?: number | undefined;
    /**
     * Function invoked when the timer ticks
     */
    onTick?: ((details: TickDetails) => void) | undefined;
    /**
     * Function invoked when the timer is completed
     */
    onComplete?: (() => void) | undefined;
}
type PropsWithDefault = "interval";
interface Context {
    /**
     * The timer count in milliseconds.
     */
    currentMs: number;
}
interface Computed {
    /**
     * The time parts of the timer count.
     */
    time: Time;
    /**
     * The formatted time parts of the timer count.
     */
    formattedTime: Time<string>;
    /**
     * The progress percentage of the timer.
     */
    progressPercent: number;
}
interface TimerSchema {
    state: "idle" | "running" | "paused" | "running:temp";
    props: RequiredBy<TimerProps, PropsWithDefault>;
    context: Context;
    computed: Computed;
    event: EventObject;
    action: string;
    effect: string;
    guard: string;
}
type TimerService = Service<TimerSchema>;
type TimerMachine = Machine<TimerSchema>;
interface ItemProps {
    type: TimePart;
}
interface ActionTriggerProps {
    action: TimerAction;
}
interface TimerApi<T extends PropTypes = PropTypes> {
    /**
     * Whether the timer is running.
     */
    running: boolean;
    /**
     * Whether the timer is paused.
     */
    paused: boolean;
    /**
     * The formatted timer count value.
     */
    time: Time;
    /**
     * The formatted time parts of the timer count.
     */
    formattedTime: Time<string>;
    /**
     * Function to start the timer.
     */
    start(): void;
    /**
     * Function to pause the timer.
     */
    pause(): void;
    /**
     * Function to resume the timer.
     */
    resume(): void;
    /**
     * Function to reset the timer.
     */
    reset(): void;
    /**
     * Function to restart the timer.
     */
    restart(): void;
    /**
     * The progress percentage of the timer.
     */
    progressPercent: number;
    getRootProps(): T["element"];
    getAreaProps(): T["element"];
    getControlProps(): T["element"];
    getItemProps(props: ItemProps): T["element"];
    getItemValueProps(props: ItemProps): T["element"];
    getItemLabelProps(props: ItemProps): T["element"];
    getSeparatorProps(): T["element"];
    getActionTriggerProps(props: ActionTriggerProps): T["button"];
}

declare function connect<T extends PropTypes>(service: Service<TimerSchema>, normalize: NormalizeProps<T>): TimerApi<T>;

declare const machine: _zag_js_core.Machine<TimerSchema>;

declare function parse(date: string | Partial<Time>): number;

declare const props: (keyof TimerProps)[];
declare const splitProps: <Props extends Partial<TimerProps>>(props: Props) => [Partial<TimerProps>, Omit<Props, keyof TimerProps>];

export { type ActionTriggerProps, type TimerApi as Api, type ElementIds, type ItemProps, type TimerMachine as Machine, type TimerProps as Props, type TimerService as Service, type TickDetails, type Time, type TimePart, type TimerAction, anatomy, connect, machine, parse, props, splitProps };
