export declare const recipes: {
    badge: import("..").RecipeDefinition<{
        variant: {
            solid: {
                bg: "colorPalette.solid";
                color: "colorPalette.contrast";
            };
            subtle: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
            };
            outline: {
                color: "colorPalette.fg";
                shadow: "inset 0 0 0px 1px var(--shadow-color)";
                shadowColor: "colorPalette.muted";
            };
            surface: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
                shadow: "inset 0 0 0px 1px var(--shadow-color)";
                shadowColor: "colorPalette.muted";
            };
            plain: {
                color: "colorPalette.fg";
            };
        };
        size: {
            xs: {
                textStyle: "2xs";
                px: "1";
                minH: "4";
            };
            sm: {
                textStyle: "xs";
                px: "1.5";
                minH: "5";
            };
            md: {
                textStyle: "sm";
                px: "2";
                minH: "6";
            };
            lg: {
                textStyle: "sm";
                px: "2.5";
                minH: "7";
            };
        };
    }>;
    button: import("..").RecipeDefinition<{
        size: {
            "2xs": {
                h: "6";
                minW: "6";
                textStyle: "xs";
                px: "2";
                gap: "1";
                _icon: {
                    width: "3.5";
                    height: "3.5";
                };
            };
            xs: {
                h: "8";
                minW: "8";
                textStyle: "xs";
                px: "2.5";
                gap: "1";
                _icon: {
                    width: "4";
                    height: "4";
                };
            };
            sm: {
                h: "9";
                minW: "9";
                px: "3.5";
                textStyle: "sm";
                gap: "2";
                _icon: {
                    width: "4";
                    height: "4";
                };
            };
            md: {
                h: "10";
                minW: "10";
                textStyle: "sm";
                px: "4";
                gap: "2";
                _icon: {
                    width: "5";
                    height: "5";
                };
            };
            lg: {
                h: "11";
                minW: "11";
                textStyle: "md";
                px: "5";
                gap: "3";
                _icon: {
                    width: "5";
                    height: "5";
                };
            };
            xl: {
                h: "12";
                minW: "12";
                textStyle: "md";
                px: "5";
                gap: "2.5";
                _icon: {
                    width: "5";
                    height: "5";
                };
            };
            "2xl": {
                h: "16";
                minW: "16";
                textStyle: "lg";
                px: "7";
                gap: "3";
                _icon: {
                    width: "6";
                    height: "6";
                };
            };
        };
        variant: {
            solid: {
                bg: "colorPalette.solid";
                color: "colorPalette.contrast";
                borderColor: "transparent";
                _hover: {
                    bg: "colorPalette.solid/90";
                };
                _expanded: {
                    bg: "colorPalette.solid/90";
                };
            };
            subtle: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
                borderColor: "transparent";
                _hover: {
                    bg: "colorPalette.muted";
                };
                _expanded: {
                    bg: "colorPalette.muted";
                };
            };
            surface: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
                shadow: "0 0 0px 1px var(--shadow-color)";
                shadowColor: "colorPalette.muted";
                _hover: {
                    bg: "colorPalette.muted";
                };
                _expanded: {
                    bg: "colorPalette.muted";
                };
            };
            outline: {
                borderWidth: "1px";
                borderColor: "colorPalette.muted";
                color: "colorPalette.fg";
                _hover: {
                    bg: "colorPalette.subtle";
                };
                _expanded: {
                    bg: "colorPalette.subtle";
                };
            };
            ghost: {
                bg: "transparent";
                color: "colorPalette.fg";
                _hover: {
                    bg: "colorPalette.subtle";
                };
                _expanded: {
                    bg: "colorPalette.subtle";
                };
            };
            plain: {
                color: "colorPalette.fg";
            };
        };
    }>;
    code: import("..").RecipeDefinition<{
        variant: {
            solid: {
                bg: "colorPalette.solid";
                color: "colorPalette.contrast";
            };
            subtle: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
            };
            outline: {
                color: "colorPalette.fg";
                shadow: "inset 0 0 0px 1px var(--shadow-color)";
                shadowColor: "colorPalette.muted";
            };
            surface: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
                shadow: "inset 0 0 0px 1px var(--shadow-color)";
                shadowColor: "colorPalette.muted";
            };
            plain: {
                color: "colorPalette.fg";
            };
        };
        size: {
            xs: {
                textStyle: "2xs";
                px: "1";
                minH: "4";
            };
            sm: {
                textStyle: "xs";
                px: "1.5";
                minH: "5";
            };
            md: {
                textStyle: "sm";
                px: "2";
                minH: "6";
            };
            lg: {
                textStyle: "sm";
                px: "2.5";
                minH: "7";
            };
        };
    }>;
    container: import("..").RecipeDefinition<{
        centerContent: {
            true: {
                display: "flex";
                flexDirection: "column";
                alignItems: "center";
            };
        };
        fluid: {
            true: {
                maxWidth: "full";
            };
        };
    }>;
    heading: import("..").RecipeDefinition<{
        size: {
            xs: {
                textStyle: "xs";
            };
            sm: {
                textStyle: "sm";
            };
            md: {
                textStyle: "md";
            };
            lg: {
                textStyle: "lg";
            };
            xl: {
                textStyle: "xl";
            };
            "2xl": {
                textStyle: "2xl";
            };
            "3xl": {
                textStyle: "3xl";
            };
            "4xl": {
                textStyle: "4xl";
            };
            "5xl": {
                textStyle: "5xl";
            };
            "6xl": {
                textStyle: "6xl";
            };
            "7xl": {
                textStyle: "7xl";
            };
        };
    }>;
    input: import("..").RecipeDefinition<{
        size: {
            "2xs": {
                textStyle: "xs";
                px: "2";
                "--input-height": "sizes.7";
            };
            xs: {
                textStyle: "xs";
                px: "2";
                "--input-height": "sizes.8";
            };
            sm: {
                textStyle: "sm";
                px: "2.5";
                "--input-height": "sizes.9";
            };
            md: {
                textStyle: "sm";
                px: "3";
                "--input-height": "sizes.10";
            };
            lg: {
                textStyle: "md";
                px: "4";
                "--input-height": "sizes.11";
            };
            xl: {
                textStyle: "md";
                px: "4.5";
                "--input-height": "sizes.12";
            };
            "2xl": {
                textStyle: "lg";
                px: "5";
                "--input-height": "sizes.16";
            };
        };
        variant: {
            outline: {
                bg: "transparent";
                borderWidth: "1px";
                borderColor: "border";
                focusVisibleRing: "inside";
                focusRingColor: "var(--focus-color)";
            };
            subtle: {
                borderWidth: "1px";
                borderColor: "transparent";
                bg: "bg.muted";
                focusVisibleRing: "inside";
                focusRingColor: "var(--focus-color)";
            };
            flushed: {
                bg: "transparent";
                borderBottomWidth: "1px";
                borderBottomColor: "border";
                borderRadius: "0";
                px: "0";
                _focusVisible: {
                    borderColor: "var(--focus-color)";
                    boxShadow: "0px 1px 0px 0px var(--focus-color)";
                };
            };
        };
    }>;
    inputAddon: import("..").RecipeDefinition<{
        size: {
            "2xs": {
                textStyle: "xs";
                px: "2";
                "--input-height": "sizes.7";
            };
            xs: {
                textStyle: "xs";
                px: "2";
                "--input-height": "sizes.8";
            };
            sm: {
                textStyle: "sm";
                px: "2.5";
                "--input-height": "sizes.9";
            };
            md: {
                textStyle: "sm";
                px: "3";
                "--input-height": "sizes.10";
            };
            lg: {
                textStyle: "md";
                px: "4";
                "--input-height": "sizes.11";
            };
            xl: {
                textStyle: "md";
                px: "4.5";
                "--input-height": "sizes.12";
            };
            "2xl": {
                textStyle: "lg";
                px: "5";
                "--input-height": "sizes.16";
            };
        };
        variant: {
            outline: {
                borderWidth: "1px";
                borderColor: "border";
                bg: "bg.muted";
            };
            subtle: {
                borderWidth: "1px";
                borderColor: "transparent";
                bg: "bg.emphasized";
            };
            flushed: {
                borderBottom: "1px solid";
                borderColor: "inherit";
                borderRadius: "0";
                px: "0";
                bg: "transparent";
            };
        };
    }>;
    kbd: import("..").RecipeDefinition<{
        variant: {
            raised: {
                bg: "colorPalette.subtle";
                color: "colorPalette.fg";
                borderWidth: "1px";
                borderBottomWidth: "2px";
                borderColor: "colorPalette.muted";
            };
            outline: {
                borderWidth: "1px";
                color: "colorPalette.fg";
            };
            subtle: {
                bg: "colorPalette.muted";
                color: "colorPalette.fg";
            };
            plain: {
                color: "colorPalette.fg";
            };
        };
        size: {
            sm: {
                textStyle: "xs";
                height: "4.5";
            };
            md: {
                textStyle: "sm";
                height: "5";
            };
            lg: {
                textStyle: "md";
                height: "6";
            };
        };
    }>;
    link: import("..").RecipeDefinition<{
        variant: {
            underline: {
                color: "colorPalette.fg";
                textDecoration: "underline";
                textUnderlineOffset: "3px";
                textDecorationColor: "currentColor/20";
            };
            plain: {
                color: "colorPalette.fg";
                _hover: {
                    textDecoration: "underline";
                    textUnderlineOffset: "3px";
                    textDecorationColor: "currentColor/20";
                };
            };
        };
    }>;
    mark: import("..").RecipeDefinition<{
        variant: {
            subtle: {
                bg: "colorPalette.subtle";
                color: "inherit";
            };
            solid: {
                bg: "colorPalette.solid";
                color: "colorPalette.contrast";
            };
            text: {
                fontWeight: "medium";
            };
            plain: {};
        };
    }>;
    separator: import("..").RecipeDefinition<{
        variant: {
            solid: {
                borderStyle: "solid";
            };
            dashed: {
                borderStyle: "dashed";
            };
            dotted: {
                borderStyle: "dotted";
            };
        };
        orientation: {
            vertical: {
                borderInlineStartWidth: "var(--separator-thickness)";
            };
            horizontal: {
                borderTopWidth: "var(--separator-thickness)";
            };
        };
        size: {
            xs: {
                "--separator-thickness": "0.5px";
            };
            sm: {
                "--separator-thickness": "1px";
            };
            md: {
                "--separator-thickness": "2px";
            };
            lg: {
                "--separator-thickness": "3px";
            };
        };
    }>;
    skeleton: import("..").RecipeDefinition<{
        loading: {
            true: {
                borderRadius: "l2";
                boxShadow: "none";
                backgroundClip: "padding-box";
                cursor: "default";
                color: "transparent";
                pointerEvents: "none";
                userSelect: "none";
                flexShrink: "0";
                "&::before, &::after, *": {
                    visibility: "hidden";
                };
            };
            false: {
                background: "unset";
                animation: "fade-in var(--fade-duration, 0.1s) ease-out !important";
            };
        };
        variant: {
            pulse: {
                background: "bg.emphasized";
                animation: "pulse";
                animationDuration: "var(--duration, 1.2s)";
            };
            shine: {
                "--animate-from": "200%";
                "--animate-to": "-200%";
                "--start-color": "colors.bg.muted";
                "--end-color": "colors.bg.emphasized";
                backgroundImage: "linear-gradient(270deg,var(--start-color),var(--end-color),var(--end-color),var(--start-color))";
                backgroundSize: "400% 100%";
                animation: "bg-position var(--duration, 5s) ease-in-out infinite";
            };
            none: {
                animation: "none";
            };
        };
    }>;
    skipNavLink: import("..").RecipeDefinition<import("..").RecipeVariantRecord>;
    spinner: import("..").RecipeDefinition<{
        size: {
            inherit: {
                "--spinner-size": "1em";
            };
            xs: {
                "--spinner-size": "sizes.3";
            };
            sm: {
                "--spinner-size": "sizes.4";
            };
            md: {
                "--spinner-size": "sizes.5";
            };
            lg: {
                "--spinner-size": "sizes.8";
            };
            xl: {
                "--spinner-size": "sizes.10";
            };
        };
    }>;
    textarea: import("..").RecipeDefinition<{
        size: {
            xs: {
                textStyle: "xs";
                px: "2";
                py: "1.5";
                scrollPaddingBottom: "1.5";
            };
            sm: {
                textStyle: "sm";
                px: "2.5";
                py: "2";
                scrollPaddingBottom: "2";
            };
            md: {
                textStyle: "sm";
                px: "3";
                py: "2";
                scrollPaddingBottom: "2";
            };
            lg: {
                textStyle: "md";
                px: "4";
                py: "3";
                scrollPaddingBottom: "3";
            };
            xl: {
                textStyle: "md";
                px: "4.5";
                py: "3.5";
                scrollPaddingBottom: "3.5";
            };
        };
        variant: {
            outline: {
                bg: "transparent";
                borderWidth: "1px";
                borderColor: "border";
                focusVisibleRing: "inside";
            };
            subtle: {
                borderWidth: "1px";
                borderColor: "transparent";
                bg: "bg.muted";
                focusVisibleRing: "inside";
            };
            flushed: {
                bg: "transparent";
                borderBottomWidth: "1px";
                borderBottomColor: "border";
                borderRadius: "0";
                px: "0";
                _focusVisible: {
                    borderColor: "var(--focus-color)";
                    boxShadow: "0px 1px 0px 0px var(--focus-color)";
                };
            };
        };
    }>;
    icon: import("..").RecipeDefinition<{
        size: {
            inherit: {};
            xs: {
                boxSize: "3";
            };
            sm: {
                boxSize: "4";
            };
            md: {
                boxSize: "5";
            };
            lg: {
                boxSize: "6";
            };
            xl: {
                boxSize: "7";
            };
            "2xl": {
                boxSize: "8";
            };
        };
    }>;
    checkmark: import("..").RecipeDefinition<{
        size: {
            xs: {
                boxSize: "3";
            };
            sm: {
                boxSize: "4";
            };
            md: {
                boxSize: "5";
                p: "0.5";
            };
            lg: {
                boxSize: "6";
                p: "0.5";
            };
        };
        variant: {
            solid: {
                borderColor: "border";
                "&:is([data-state=checked], [data-state=indeterminate])": {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                    borderColor: "colorPalette.solid";
                };
            };
            outline: {
                borderColor: "border";
                "&:is([data-state=checked], [data-state=indeterminate])": {
                    color: "colorPalette.fg";
                    borderColor: "colorPalette.solid";
                };
            };
            subtle: {
                bg: "colorPalette.muted";
                borderColor: "colorPalette.muted";
                "&:is([data-state=checked], [data-state=indeterminate])": {
                    color: "colorPalette.fg";
                };
            };
            plain: {
                "&:is([data-state=checked], [data-state=indeterminate])": {
                    color: "colorPalette.fg";
                };
            };
            inverted: {
                borderColor: "border";
                color: "colorPalette.fg";
                "&:is([data-state=checked], [data-state=indeterminate])": {
                    borderColor: "colorPalette.solid";
                };
            };
        };
    }>;
    radiomark: import("..").RecipeDefinition<{
        variant: {
            solid: {
                borderWidth: "1px";
                borderColor: "border";
                _checked: {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                    borderColor: "colorPalette.solid";
                };
            };
            subtle: {
                borderWidth: "1px";
                bg: "colorPalette.muted";
                borderColor: "colorPalette.muted";
                color: "transparent";
                _checked: {
                    color: "colorPalette.fg";
                };
            };
            outline: {
                borderWidth: "1px";
                borderColor: "inherit";
                _checked: {
                    color: "colorPalette.fg";
                    borderColor: "colorPalette.solid";
                };
                "& .dot": {
                    scale: "0.6";
                };
            };
            inverted: {
                bg: "bg";
                borderWidth: "1px";
                borderColor: "inherit";
                _checked: {
                    color: "colorPalette.solid";
                    borderColor: "currentcolor";
                };
            };
        };
        size: {
            xs: {
                boxSize: "3";
            };
            sm: {
                boxSize: "4";
            };
            md: {
                boxSize: "5";
            };
            lg: {
                boxSize: "6";
            };
        };
    }>;
    colorSwatch: import("..").RecipeDefinition<{
        size: {
            "2xs": {
                "--swatch-size": "sizes.3.5";
            };
            xs: {
                "--swatch-size": "sizes.4";
            };
            sm: {
                "--swatch-size": "sizes.4.5";
            };
            md: {
                "--swatch-size": "sizes.5";
            };
            lg: {
                "--swatch-size": "sizes.6";
            };
            xl: {
                "--swatch-size": "sizes.7";
            };
            "2xl": {
                "--swatch-size": "sizes.8";
            };
            inherit: {
                "--swatch-size": "inherit";
            };
            full: {
                "--swatch-size": "100%";
            };
        };
        shape: {
            square: {
                borderRadius: "none";
            };
            circle: {
                borderRadius: "full";
            };
            rounded: {
                borderRadius: "l1";
            };
        };
    }>;
};
