import type { Assign } from "@ark-ui/react";
import { Pagination as ArkPagination } from "@ark-ui/react/pagination";
import { type HTMLChakraProps, type SlotRecipeProps, type UnstyledProp } from "../../styled-system";
import { type BoxProps } from "../box";
declare const usePaginationStyles: () => Record<string, import("../..").SystemStyleObject>;
export { usePaginationStyles };
export interface PaginationRootProviderBaseProps extends Assign<ArkPagination.RootProviderBaseProps, SlotRecipeProps<"pagination">>, UnstyledProp {
}
export interface PaginationRootProviderProps extends HTMLChakraProps<"div", PaginationRootProviderBaseProps> {
}
export declare const PaginationRootProvider: import("react").ForwardRefExoticComponent<PaginationRootProviderProps & import("react").RefAttributes<HTMLDivElement>>;
export interface PaginationRootBaseProps extends Assign<ArkPagination.RootBaseProps, SlotRecipeProps<"pagination">>, UnstyledProp {
}
export interface PaginationRootProps extends HTMLChakraProps<"div", PaginationRootBaseProps> {
}
export declare const PaginationRoot: import("react").ForwardRefExoticComponent<PaginationRootProps & import("react").RefAttributes<HTMLDivElement>>;
export declare const PaginationPropsProvider: React.Provider<PaginationRootBaseProps>;
export interface PaginationEllipsisProps extends HTMLChakraProps<"div", ArkPagination.EllipsisBaseProps> {
}
export declare const PaginationEllipsis: import("react").ForwardRefExoticComponent<PaginationEllipsisProps & import("react").RefAttributes<HTMLDivElement>>;
export interface PaginationItemProps extends HTMLChakraProps<"button", ArkPagination.ItemBaseProps> {
}
export declare const PaginationItem: import("react").ForwardRefExoticComponent<PaginationItemProps & import("react").RefAttributes<HTMLButtonElement>>;
export interface PaginationNextTriggerProps extends HTMLChakraProps<"button", ArkPagination.NextTriggerBaseProps> {
}
export declare const PaginationNextTrigger: import("react").ForwardRefExoticComponent<PaginationNextTriggerProps & import("react").RefAttributes<HTMLButtonElement>>;
export interface PaginationPrevTriggerProps extends HTMLChakraProps<"button", ArkPagination.PrevTriggerBaseProps> {
}
export declare const PaginationPrevTrigger: import("react").ForwardRefExoticComponent<PaginationPrevTriggerProps & import("react").RefAttributes<HTMLButtonElement>>;
export declare const PaginationContext: (props: ArkPagination.ContextProps) => import("react").ReactNode;
export interface PaginationPageChangeDetails extends ArkPagination.PageChangeDetails {
}
export interface PaginationPageSizeChangeDetails extends ArkPagination.PageSizeChangeDetails {
}
export interface PaginationPageTextProps extends BoxProps {
    format?: "short" | "compact" | "long";
}
export declare const PaginationPageText: import("react").ForwardRefExoticComponent<PaginationPageTextProps & import("react").RefAttributes<HTMLParagraphElement>>;
export interface PaginationItemsProps extends React.HTMLAttributes<HTMLElement> {
    render: (page: {
        type: "page";
        value: number;
    }) => React.ReactNode;
    ellipsis?: React.ReactElement;
}
export declare const PaginationItems: (props: PaginationItemsProps) => import("react/jsx-runtime").JSX.Element;
