import type { Assign } from "@ark-ui/react";
import { FileUpload as ArkFileUpload } from "@ark-ui/react/file-upload";
import { type HTMLChakraProps, type SlotRecipeProps, type UnstyledProp } from "../../styled-system";
declare const useFileUploadStyles: () => Record<string, import("../..").SystemStyleObject>;
export { useFileUploadStyles };
export interface FileUploadRootProviderBaseProps extends Assign<ArkFileUpload.RootProviderBaseProps, SlotRecipeProps<"fileUpload">>, UnstyledProp {
}
export interface FileUploadRootProviderProps extends HTMLChakraProps<"div", FileUploadRootProviderBaseProps> {
}
export declare const FileUploadRootProvider: import("react").ForwardRefExoticComponent<FileUploadRootProviderProps & import("react").RefAttributes<HTMLDivElement>>;
export interface FileUploadRootBaseProps extends Assign<ArkFileUpload.RootBaseProps, SlotRecipeProps<"fileUpload">>, UnstyledProp {
}
export interface FileUploadRootProps extends HTMLChakraProps<"div", FileUploadRootBaseProps> {
}
export declare const FileUploadRoot: import("react").ForwardRefExoticComponent<FileUploadRootProps & import("react").RefAttributes<HTMLDivElement>>;
export declare const FileUploadPropsProvider: React.Provider<FileUploadRootBaseProps>;
export interface FileUploadClearTriggerProps extends HTMLChakraProps<"button"> {
}
export declare const FileUploadClearTrigger: import("react").ForwardRefExoticComponent<FileUploadClearTriggerProps & import("react").RefAttributes<HTMLButtonElement>>;
export interface FileUploadDropzoneProps extends HTMLChakraProps<"li", ArkFileUpload.DropzoneBaseProps> {
}
export declare const FileUploadDropzone: import("react").ForwardRefExoticComponent<FileUploadDropzoneProps & import("react").RefAttributes<HTMLDivElement>>;
export interface FileUploadDropzoneContentProps extends HTMLChakraProps<"div"> {
}
export declare const FileUploadDropzoneContent: import("react").ForwardRefExoticComponent<FileUploadDropzoneContentProps & import("react").RefAttributes<HTMLDivElement>>;
export interface FileUploadItemProps extends HTMLChakraProps<"li", ArkFileUpload.ItemBaseProps> {
}
export declare const FileUploadItem: import("react").ForwardRefExoticComponent<FileUploadItemProps & import("react").RefAttributes<HTMLLIElement>>;
export interface FileUploadItemContentProps extends HTMLChakraProps<"div"> {
}
export declare const FileUploadItemContent: import("react").ForwardRefExoticComponent<FileUploadItemContentProps & import("react").RefAttributes<HTMLDivElement>>;
export interface FileUploadItemDeleteTriggerProps extends HTMLChakraProps<"button", ArkFileUpload.ItemDeleteTriggerBaseProps> {
}
export declare const FileUploadItemDeleteTrigger: import("react").ForwardRefExoticComponent<FileUploadItemDeleteTriggerProps & import("react").RefAttributes<HTMLButtonElement>>;
export interface FileUploadItemGroupProps extends HTMLChakraProps<"ul", ArkFileUpload.ItemGroupBaseProps> {
}
export declare const FileUploadItemGroup: import("react").ForwardRefExoticComponent<FileUploadItemGroupProps & import("react").RefAttributes<HTMLUListElement>>;
export interface FileUploadItemNameProps extends HTMLChakraProps<"span", ArkFileUpload.ItemNameBaseProps> {
}
export declare const FileUploadItemName: import("react").ForwardRefExoticComponent<FileUploadItemNameProps & import("react").RefAttributes<HTMLSpanElement>>;
export interface FileUploadItemPreviewProps extends HTMLChakraProps<"div", ArkFileUpload.ItemPreviewBaseProps> {
}
export declare const FileUploadItemPreview: import("react").ForwardRefExoticComponent<FileUploadItemPreviewProps & import("react").RefAttributes<HTMLDivElement>>;
export interface FileUploadItemPreviewImageProps extends HTMLChakraProps<"img", ArkFileUpload.ItemPreviewImageBaseProps> {
}
export declare const FileUploadItemPreviewImage: import("react").ForwardRefExoticComponent<FileUploadItemPreviewImageProps & import("react").RefAttributes<HTMLImageElement>>;
export interface FileUploadItemSizeTextProps extends HTMLChakraProps<"span", ArkFileUpload.ItemSizeTextBaseProps> {
}
export declare const FileUploadItemSizeText: import("react").ForwardRefExoticComponent<FileUploadItemSizeTextProps & import("react").RefAttributes<HTMLSpanElement>>;
export interface FileUploadLabelProps extends HTMLChakraProps<"label", ArkFileUpload.LabelBaseProps> {
}
export declare const FileUploadLabel: import("react").ForwardRefExoticComponent<FileUploadLabelProps & import("react").RefAttributes<HTMLLabelElement>>;
export interface FileUploadTriggerProps extends HTMLChakraProps<"button", ArkFileUpload.TriggerBaseProps> {
}
export declare const FileUploadTrigger: import("react").ForwardRefExoticComponent<FileUploadTriggerProps & import("react").RefAttributes<HTMLButtonElement>>;
export interface FileUploadItemsBaseProps {
    showSize?: boolean;
    clearable?: boolean;
    files?: File[];
}
export interface FileUploadItemsProps extends Omit<FileUploadItemProps, "file">, FileUploadItemsBaseProps {
}
export declare const FileUploadItems: (props: FileUploadItemsProps) => import("react/jsx-runtime").JSX.Element;
export interface FileUploadListProps extends FileUploadItemsBaseProps {
}
export declare const FileUploadList: import("react").ForwardRefExoticComponent<FileUploadListProps & import("react").RefAttributes<HTMLUListElement>>;
export interface FileUploadFileTextProps extends HTMLChakraProps<"span"> {
    fallback?: string;
}
export declare const FileUploadFileText: import("react").ForwardRefExoticComponent<FileUploadFileTextProps & import("react").RefAttributes<HTMLSpanElement>>;
export declare const FileUploadContext: (props: ArkFileUpload.ContextProps) => import("react").ReactNode;
export declare const FileUploadHiddenInput: import("react").ForwardRefExoticComponent<ArkFileUpload.HiddenInputProps & import("react").RefAttributes<HTMLInputElement>>;
export interface FileUploadFileAcceptDetails extends ArkFileUpload.FileAcceptDetails {
}
export interface FileUploadFileRejectDetails extends ArkFileUpload.FileRejectDetails {
}
export interface FileUploadFileChangeDetails extends ArkFileUpload.FileChangeDetails {
}
