"use strict";
import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { Span } from '../box/span.js';
import { AbsoluteCenter } from '../center/absolute-center.js';
import { Spinner } from '../spinner/spinner.js';

const Loader = React.forwardRef(
  function Loader2(props, ref) {
    const {
      spinner = /* @__PURE__ */ jsx(Spinner, { size: "inherit", borderWidth: "0.125em", color: "inherit" }),
      spinnerPlacement = "start",
      children,
      text,
      visible = true,
      ...rest
    } = props;
    if (!visible) return children;
    if (text) {
      return /* @__PURE__ */ jsxs(Span, { ref, display: "contents", ...rest, children: [
        spinnerPlacement === "start" && spinner,
        text,
        spinnerPlacement === "end" && spinner
      ] });
    }
    if (spinner) {
      return /* @__PURE__ */ jsxs(Span, { ref, display: "contents", ...rest, children: [
        /* @__PURE__ */ jsx(AbsoluteCenter, { display: "inline-flex", children: spinner }),
        /* @__PURE__ */ jsx(Span, { opacity: 0, children })
      ] });
    }
    return /* @__PURE__ */ jsx(Span, { ref, display: "contents", ...rest, children });
  }
);

export { Loader };
