'use client';
'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const react$1 = require('@zag-js/react');
const react = require('react');
const createSplitProps = require('../../utils/create-split-props.cjs');
const factory = require('../factory.cjs');
const useMenuContext = require('./use-menu-context.cjs');
const useMenuItemContext = require('./use-menu-item-context.cjs');

const MenuItem = react.forwardRef((props, ref) => {
  const [itemProps, localProps] = createSplitProps.createSplitProps()(props, [
    "closeOnSelect",
    "disabled",
    "value",
    "valueText",
    "onSelect"
  ]);
  const menu = useMenuContext.useMenuContext();
  const mergedProps = react$1.mergeProps(menu.getItemProps(itemProps), localProps);
  const itemState = menu.getItemState(itemProps);
  react.useEffect(() => {
    return menu.addItemListener({ id: itemState.id, onSelect: itemProps.onSelect });
  }, [itemState.id, itemProps.onSelect]);
  return /* @__PURE__ */ jsxRuntime.jsx(useMenuItemContext.MenuItemProvider, { value: itemState, children: /* @__PURE__ */ jsxRuntime.jsx(factory.ark.div, { ...mergedProps, ref }) });
});
MenuItem.displayName = "MenuItem";

exports.MenuItem = MenuItem;
