import {
  require_react
} from "./chunk-7EEON6PG.js";
import {
  __toESM
} from "./chunk-4B2QHNJT.js";

// node_modules/react-sketch-canvas/dist/react-sketch-canvas.esm.js
var React = __toESM(require_react());
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function _asyncToGenerator(fn) {
  return function() {
    var self = this, args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(void 0);
    });
  };
}
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
var runtime = { exports: {} };
(function(module) {
  var runtime2 = function(exports) {
    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var undefined$1;
    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    function define(obj, key, value) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
      return obj[key];
    }
    try {
      define({}, "");
    } catch (err) {
      define = function(obj, key, value) {
        return obj[key] = value;
      };
    }
    function wrap(innerFn, outerFn, self, tryLocsList) {
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context = new Context(tryLocsList || []);
      generator._invoke = makeInvokeMethod(innerFn, self, context);
      return generator;
    }
    exports.wrap = wrap;
    function tryCatch(fn, obj, arg) {
      try {
        return { type: "normal", arg: fn.call(obj, arg) };
      } catch (err) {
        return { type: "throw", arg: err };
      }
    }
    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed";
    var ContinueSentinel = {};
    function Generator() {
    }
    function GeneratorFunction() {
    }
    function GeneratorFunctionPrototype() {
    }
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function() {
      return this;
    });
    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      IteratorPrototype = NativeIteratorPrototype;
    }
    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = GeneratorFunctionPrototype;
    define(Gp, "constructor", GeneratorFunctionPrototype);
    define(GeneratorFunctionPrototype, "constructor", GeneratorFunction);
    GeneratorFunction.displayName = define(
      GeneratorFunctionPrototype,
      toStringTagSymbol,
      "GeneratorFunction"
    );
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function(method) {
        define(prototype, method, function(arg) {
          return this._invoke(method, arg);
        });
      });
    }
    exports.isGeneratorFunction = function(genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
      // do is to check its .name property.
      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
    };
    exports.mark = function(genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        define(genFun, toStringTagSymbol, "GeneratorFunction");
      }
      genFun.prototype = Object.create(Gp);
      return genFun;
    };
    exports.awrap = function(arg) {
      return { __await: arg };
    };
    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;
          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
            return PromiseImpl.resolve(value.__await).then(function(value2) {
              invoke("next", value2, resolve, reject);
            }, function(err) {
              invoke("throw", err, resolve, reject);
            });
          }
          return PromiseImpl.resolve(value).then(function(unwrapped) {
            result.value = unwrapped;
            resolve(result);
          }, function(error) {
            return invoke("throw", error, resolve, reject);
          });
        }
      }
      var previousPromise;
      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function(resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }
        return previousPromise = // If enqueue has been called before, then we want to wait until
        // all previous Promises have been resolved before calling invoke,
        // so that results are always delivered in the correct order. If
        // enqueue has not been called before, then it is important to
        // call invoke immediately, without waiting on a callback to fire,
        // so that the async generator function has the opportunity to do
        // any necessary setup in a predictable way. This predictability
        // is why the Promise constructor synchronously invokes its
        // executor callback, and why async functions synchronously
        // execute code before the first await. Since we implement simple
        // async functions in terms of async generators, it is especially
        // important to get this right, even though it requires care.
        previousPromise ? previousPromise.then(
          callInvokeWithMethodAndArg,
          // Avoid propagating failures to Promises returned by later
          // invocations of the iterator.
          callInvokeWithMethodAndArg
        ) : callInvokeWithMethodAndArg();
      }
      this._invoke = enqueue;
    }
    defineIteratorMethods(AsyncIterator.prototype);
    define(AsyncIterator.prototype, asyncIteratorSymbol, function() {
      return this;
    });
    exports.AsyncIterator = AsyncIterator;
    exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      if (PromiseImpl === void 0) PromiseImpl = Promise;
      var iter = new AsyncIterator(
        wrap(innerFn, outerFn, self, tryLocsList),
        PromiseImpl
      );
      return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function(result) {
        return result.done ? result.value : iter.next();
      });
    };
    function makeInvokeMethod(innerFn, self, context) {
      var state = GenStateSuspendedStart;
      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }
        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          }
          return doneResult();
        }
        context.method = method;
        context.arg = arg;
        while (true) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }
          if (context.method === "next") {
            context.sent = context._sent = context.arg;
          } else if (context.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context.arg;
            }
            context.dispatchException(context.arg);
          } else if (context.method === "return") {
            context.abrupt("return", context.arg);
          }
          state = GenStateExecuting;
          var record = tryCatch(innerFn, self, context);
          if (record.type === "normal") {
            state = context.done ? GenStateCompleted : GenStateSuspendedYield;
            if (record.arg === ContinueSentinel) {
              continue;
            }
            return {
              value: record.arg,
              done: context.done
            };
          } else if (record.type === "throw") {
            state = GenStateCompleted;
            context.method = "throw";
            context.arg = record.arg;
          }
        }
      };
    }
    function maybeInvokeDelegate(delegate, context) {
      var method = delegate.iterator[context.method];
      if (method === undefined$1) {
        context.delegate = null;
        if (context.method === "throw") {
          if (delegate.iterator["return"]) {
            context.method = "return";
            context.arg = undefined$1;
            maybeInvokeDelegate(delegate, context);
            if (context.method === "throw") {
              return ContinueSentinel;
            }
          }
          context.method = "throw";
          context.arg = new TypeError(
            "The iterator does not provide a 'throw' method"
          );
        }
        return ContinueSentinel;
      }
      var record = tryCatch(method, delegate.iterator, context.arg);
      if (record.type === "throw") {
        context.method = "throw";
        context.arg = record.arg;
        context.delegate = null;
        return ContinueSentinel;
      }
      var info = record.arg;
      if (!info) {
        context.method = "throw";
        context.arg = new TypeError("iterator result is not an object");
        context.delegate = null;
        return ContinueSentinel;
      }
      if (info.done) {
        context[delegate.resultName] = info.value;
        context.next = delegate.nextLoc;
        if (context.method !== "return") {
          context.method = "next";
          context.arg = undefined$1;
        }
      } else {
        return info;
      }
      context.delegate = null;
      return ContinueSentinel;
    }
    defineIteratorMethods(Gp);
    define(Gp, toStringTagSymbol, "Generator");
    define(Gp, iteratorSymbol, function() {
      return this;
    });
    define(Gp, "toString", function() {
      return "[object Generator]";
    });
    function pushTryEntry(locs) {
      var entry = { tryLoc: locs[0] };
      if (1 in locs) {
        entry.catchLoc = locs[1];
      }
      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }
      this.tryEntries.push(entry);
    }
    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }
    function Context(tryLocsList) {
      this.tryEntries = [{ tryLoc: "root" }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }
    exports.keys = function(object) {
      var keys = [];
      for (var key in object) {
        keys.push(key);
      }
      keys.reverse();
      return function next() {
        while (keys.length) {
          var key2 = keys.pop();
          if (key2 in object) {
            next.value = key2;
            next.done = false;
            return next;
          }
        }
        next.done = true;
        return next;
      };
    };
    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }
        if (typeof iterable.next === "function") {
          return iterable;
        }
        if (!isNaN(iterable.length)) {
          var i = -1, next = function next2() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next2.value = iterable[i];
                next2.done = false;
                return next2;
              }
            }
            next2.value = undefined$1;
            next2.done = true;
            return next2;
          };
          return next.next = next;
        }
      }
      return { next: doneResult };
    }
    exports.values = values;
    function doneResult() {
      return { value: undefined$1, done: true };
    }
    Context.prototype = {
      constructor: Context,
      reset: function(skipTempReset) {
        this.prev = 0;
        this.next = 0;
        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;
        this.method = "next";
        this.arg = undefined$1;
        this.tryEntries.forEach(resetTryEntry);
        if (!skipTempReset) {
          for (var name in this) {
            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
              this[name] = undefined$1;
            }
          }
        }
      },
      stop: function() {
        this.done = true;
        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;
        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }
        return this.rval;
      },
      dispatchException: function(exception) {
        if (this.done) {
          throw exception;
        }
        var context = this;
        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context.next = loc;
          if (caught) {
            context.method = "next";
            context.arg = undefined$1;
          }
          return !!caught;
        }
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;
          if (entry.tryLoc === "root") {
            return handle("end");
          }
          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");
            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }
            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },
      abrupt: function(type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }
        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
          finallyEntry = null;
        }
        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type;
        record.arg = arg;
        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }
        return this.complete(record);
      },
      complete: function(record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }
        if (record.type === "break" || record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }
        return ContinueSentinel;
      },
      finish: function(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },
      "catch": function(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }
        throw new Error("illegal catch attempt");
      },
      delegateYield: function(iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName,
          nextLoc
        };
        if (this.method === "next") {
          this.arg = undefined$1;
        }
        return ContinueSentinel;
      }
    };
    return exports;
  }(
    // If this script is executing as a CommonJS module, use module.exports
    // as the regeneratorRuntime namespace. Otherwise create a new empty
    // object. Either way, the resulting object will be used to initialize
    // the regeneratorRuntime variable at the top of this file.
    module.exports
  );
  try {
    regeneratorRuntime = runtime2;
  } catch (accidentalStrictMode) {
    if (typeof globalThis === "object") {
      globalThis.regeneratorRuntime = runtime2;
    } else {
      Function("r", "regeneratorRuntime = r")(runtime2);
    }
  }
})(runtime);
var _regeneratorRuntime = runtime.exports;
var SvgPath = function SvgPath2(_ref) {
  var paths = _ref.paths, id = _ref.id, strokeWidth = _ref.strokeWidth, strokeColor = _ref.strokeColor, _ref$command = _ref.command, command = _ref$command === void 0 ? bezierCommand : _ref$command;
  if (paths.length === 1) {
    var _paths$ = paths[0], x = _paths$.x, y = _paths$.y;
    var radius = strokeWidth / 2;
    return React.createElement("circle", {
      key: id,
      id,
      cx: x,
      cy: y,
      r: radius,
      stroke: strokeColor,
      fill: strokeColor
    });
  }
  var d = paths.reduce(function(acc, point, i, a) {
    return i === 0 ? "M " + point.x + "," + point.y : acc + " " + command(point, i, a);
  }, "");
  return React.createElement("path", {
    key: id,
    id,
    d,
    fill: "none",
    strokeLinecap: "round",
    stroke: strokeColor,
    strokeWidth
  });
};
var line = function line2(pointA, pointB) {
  var lengthX = pointB.x - pointA.x;
  var lengthY = pointB.y - pointA.y;
  return {
    length: Math.sqrt(Math.pow(lengthX, 2) + Math.pow(lengthY, 2)),
    angle: Math.atan2(lengthY, lengthX)
  };
};
var controlPoint = function controlPoint2(controlPoints) {
  var current = controlPoints.current, next = controlPoints.next, previous = controlPoints.previous, reverse = controlPoints.reverse;
  var p = previous || current;
  var n = next || current;
  var smoothing = 0.2;
  var o = line(p, n);
  var angle = o.angle + (reverse ? Math.PI : 0);
  var length = o.length * smoothing;
  var x = current.x + Math.cos(angle) * length;
  var y = current.y + Math.sin(angle) * length;
  return [x, y];
};
var bezierCommand = function bezierCommand2(point, i, a) {
  var cpsX = null;
  var cpsY = null;
  switch (i) {
    case 0:
      var _controlPoint = controlPoint({
        current: point
      });
      cpsX = _controlPoint[0];
      cpsY = _controlPoint[1];
      break;
    case 1:
      var _controlPoint2 = controlPoint({
        current: a[i - 1],
        next: point
      });
      cpsX = _controlPoint2[0];
      cpsY = _controlPoint2[1];
      break;
    default:
      var _controlPoint3 = controlPoint({
        current: a[i - 1],
        previous: a[i - 2],
        next: point
      });
      cpsX = _controlPoint3[0];
      cpsY = _controlPoint3[1];
      break;
  }
  var _controlPoint4 = controlPoint({
    current: point,
    previous: a[i - 1],
    next: a[i + 1],
    reverse: true
  }), cpeX = _controlPoint4[0], cpeY = _controlPoint4[1];
  return "C " + cpsX + "," + cpsY + " " + cpeX + "," + cpeY + " " + point.x + ", " + point.y;
};
var Paths = function Paths2(_ref2) {
  var id = _ref2.id, paths = _ref2.paths;
  return React.createElement(React.Fragment, null, paths.map(function(path, index) {
    return React.createElement(SvgPath, {
      key: id + "__" + index,
      paths: path.paths,
      id: id + "__" + index,
      strokeWidth: path.strokeWidth,
      strokeColor: path.strokeColor,
      command: bezierCommand
    });
  }));
};
var loadImage = function loadImage2(url) {
  return new Promise(function(resolve, reject) {
    var img = new Image();
    img.addEventListener("load", function() {
      if (img.width > 0) {
        resolve(img);
      }
      reject("Image not found");
    });
    img.addEventListener("error", function(err) {
      return reject(err);
    });
    img.src = url;
    img.setAttribute("crossorigin", "anonymous");
  });
};
function getCanvasWithViewBox(canvas) {
  var _canvas$firstChild;
  var svgCanvas = (_canvas$firstChild = canvas.firstChild) == null ? void 0 : _canvas$firstChild.cloneNode(true);
  var width = canvas.offsetWidth;
  var height = canvas.offsetHeight;
  svgCanvas.setAttribute("viewBox", "0 0 " + width + " " + height);
  svgCanvas.setAttribute("width", width.toString());
  svgCanvas.setAttribute("height", height.toString());
  return {
    svgCanvas,
    width,
    height
  };
}
var Canvas = React.forwardRef(function(props, ref) {
  var paths = props.paths, isDrawing = props.isDrawing, onPointerDown = props.onPointerDown, onPointerMove = props.onPointerMove, onPointerUp = props.onPointerUp, _props$id = props.id, id = _props$id === void 0 ? "react-sketch-canvas" : _props$id, _props$width = props.width, width = _props$width === void 0 ? "100%" : _props$width, _props$height = props.height, height = _props$height === void 0 ? "100%" : _props$height, _props$className = props.className, className = _props$className === void 0 ? "react-sketch-canvas" : _props$className, _props$canvasColor = props.canvasColor, canvasColor = _props$canvasColor === void 0 ? "red" : _props$canvasColor, _props$backgroundImag = props.backgroundImage, backgroundImage = _props$backgroundImag === void 0 ? "" : _props$backgroundImag, _props$exportWithBack = props.exportWithBackgroundImage, exportWithBackgroundImage = _props$exportWithBack === void 0 ? false : _props$exportWithBack, _props$preserveBackgr = props.preserveBackgroundImageAspectRatio, preserveBackgroundImageAspectRatio = _props$preserveBackgr === void 0 ? "none" : _props$preserveBackgr, _props$allowOnlyPoint = props.allowOnlyPointerType, allowOnlyPointerType = _props$allowOnlyPoint === void 0 ? "all" : _props$allowOnlyPoint, _props$style = props.style, style = _props$style === void 0 ? {
    border: "0.0625rem solid #9c9c9c",
    borderRadius: "0.25rem"
  } : _props$style, _props$svgStyle = props.svgStyle, svgStyle = _props$svgStyle === void 0 ? {} : _props$svgStyle;
  var canvasRef = React.useRef(null);
  var getCoordinates = function getCoordinates2(pointerEvent) {
    var _canvasRef$current, _window$scrollX, _window$scrollY;
    var boundingArea = (_canvasRef$current = canvasRef.current) == null ? void 0 : _canvasRef$current.getBoundingClientRect();
    var scrollLeft = (_window$scrollX = window.scrollX) != null ? _window$scrollX : 0;
    var scrollTop = (_window$scrollY = window.scrollY) != null ? _window$scrollY : 0;
    if (!boundingArea) {
      return {
        x: 0,
        y: 0
      };
    }
    var point = {
      x: pointerEvent.pageX - boundingArea.left - scrollLeft,
      y: pointerEvent.pageY - boundingArea.top - scrollTop
    };
    return point;
  };
  var handlePointerDown = function handlePointerDown2(event) {
    if (allowOnlyPointerType !== "all" && event.pointerType !== allowOnlyPointerType) {
      return;
    }
    if (event.pointerType === "mouse" && event.button !== 0) return;
    var point = getCoordinates(event);
    onPointerDown(point);
  };
  var handlePointerMove = function handlePointerMove2(event) {
    if (!isDrawing) return;
    if (allowOnlyPointerType !== "all" && event.pointerType !== allowOnlyPointerType) {
      return;
    }
    var point = getCoordinates(event);
    onPointerMove(point);
  };
  var handlePointerUp = function handlePointerUp2(event) {
    if (event.pointerType === "mouse" && event.button !== 0) return;
    if (allowOnlyPointerType !== "all" && event.pointerType !== allowOnlyPointerType) {
      return;
    }
    onPointerUp();
  };
  React.useImperativeHandle(ref, function() {
    return {
      exportImage: function exportImage(imageType) {
        return new Promise(function() {
          var _ref = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(resolve, reject) {
            var canvas, _getCanvasWithViewBox, svgCanvas, _width, _height, canvasSketch, loadImagePromises, img;
            return _regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;
                    canvas = canvasRef.current;
                    if (canvas) {
                      _context.next = 4;
                      break;
                    }
                    throw Error("Canvas not rendered yet");
                  case 4:
                    _getCanvasWithViewBox = getCanvasWithViewBox(canvas), svgCanvas = _getCanvasWithViewBox.svgCanvas, _width = _getCanvasWithViewBox.width, _height = _getCanvasWithViewBox.height;
                    canvasSketch = "data:image/svg+xml;base64," + btoa(svgCanvas.outerHTML);
                    _context.next = 8;
                    return loadImage(canvasSketch);
                  case 8:
                    _context.t0 = _context.sent;
                    loadImagePromises = [_context.t0];
                    if (!exportWithBackgroundImage) {
                      _context.next = 21;
                      break;
                    }
                    _context.prev = 11;
                    _context.next = 14;
                    return loadImage(backgroundImage);
                  case 14:
                    img = _context.sent;
                    loadImagePromises.push(img);
                    _context.next = 21;
                    break;
                  case 18:
                    _context.prev = 18;
                    _context.t1 = _context["catch"](11);
                    console.warn("exportWithBackgroundImage props is set without a valid background image URL. This option is ignored");
                  case 21:
                    Promise.all(loadImagePromises).then(function(images) {
                      var renderCanvas = document.createElement("canvas");
                      renderCanvas.setAttribute("width", _width.toString());
                      renderCanvas.setAttribute("height", _height.toString());
                      var context = renderCanvas.getContext("2d");
                      if (!context) {
                        throw Error("Canvas not rendered yet");
                      }
                      images.reverse().forEach(function(image) {
                        context.drawImage(image, 0, 0);
                      });
                      resolve(renderCanvas.toDataURL("image/" + imageType));
                    })["catch"](function(e) {
                      throw e;
                    });
                    _context.next = 27;
                    break;
                  case 24:
                    _context.prev = 24;
                    _context.t2 = _context["catch"](0);
                    reject(_context.t2);
                  case 27:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee, null, [[0, 24], [11, 18]]);
          }));
          return function(_x, _x2) {
            return _ref.apply(this, arguments);
          };
        }());
      },
      exportSvg: function exportSvg() {
        return new Promise(function(resolve, reject) {
          try {
            var _canvasRef$current2;
            var canvas = (_canvasRef$current2 = canvasRef.current) != null ? _canvasRef$current2 : null;
            if (canvas !== null) {
              var _svgCanvas$querySelec, _svgCanvas$querySelec2;
              var _getCanvasWithViewBox2 = getCanvasWithViewBox(canvas), svgCanvas = _getCanvasWithViewBox2.svgCanvas;
              if (exportWithBackgroundImage) {
                resolve(svgCanvas.outerHTML);
                return;
              }
              (_svgCanvas$querySelec = svgCanvas.querySelector("#" + id + "__background")) == null ? void 0 : _svgCanvas$querySelec.remove();
              (_svgCanvas$querySelec2 = svgCanvas.querySelector("#" + id + "__canvas-background")) == null ? void 0 : _svgCanvas$querySelec2.setAttribute("fill", canvasColor);
              resolve(svgCanvas.outerHTML);
            }
            reject(new Error("Canvas not loaded"));
          } catch (e) {
            reject(e);
          }
        });
      }
    };
  });
  React.useEffect(function() {
    document.addEventListener("pointerup", handlePointerUp);
    return function() {
      document.removeEventListener("pointerup", handlePointerUp);
    };
  }, [handlePointerUp]);
  var eraserPaths = paths.filter(function(path) {
    return !path.drawMode;
  });
  var currentGroup = 0;
  var pathGroups = paths.reduce(function(arrayGroup, path) {
    if (!path.drawMode) {
      currentGroup += 1;
      return arrayGroup;
    }
    if (arrayGroup[currentGroup] === void 0) {
      arrayGroup[currentGroup] = [];
    }
    arrayGroup[currentGroup].push(path);
    return arrayGroup;
  }, [[]]);
  return React.createElement("div", {
    role: "presentation",
    ref: canvasRef,
    className,
    style: _extends({
      touchAction: "none",
      width,
      height
    }, style),
    "touch-action": "none",
    onPointerDown: handlePointerDown,
    onPointerMove: handlePointerMove,
    onPointerUp: handlePointerUp
  }, React.createElement("svg", {
    version: "1.1",
    baseProfile: "full",
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    style: _extends({
      width: "100%",
      height: "100%"
    }, svgStyle),
    id
  }, React.createElement("g", {
    id: id + "__eraser-stroke-group",
    display: "none"
  }, React.createElement("rect", {
    id: id + "__mask-background",
    x: "0",
    y: "0",
    width: "100%",
    height: "100%",
    fill: "white"
  }), eraserPaths.map(function(eraserPath, i) {
    return React.createElement(SvgPath, {
      key: id + "__eraser-" + i,
      id: id + "__eraser-" + i,
      paths: eraserPath.paths,
      strokeColor: "#000000",
      strokeWidth: eraserPath.strokeWidth
    });
  })), React.createElement("defs", null, backgroundImage && React.createElement("pattern", {
    id: id + "__background",
    x: "0",
    y: "0",
    width: "100%",
    height: "100%",
    patternUnits: "userSpaceOnUse"
  }, React.createElement("image", {
    x: "0",
    y: "0",
    width: "100%",
    height: "100%",
    xlinkHref: backgroundImage,
    preserveAspectRatio: preserveBackgroundImageAspectRatio
  })), eraserPaths.map(function(_, i) {
    return React.createElement("mask", {
      id: id + "__eraser-mask-" + i,
      key: id + "__eraser-mask-" + i,
      maskUnits: "userSpaceOnUse"
    }, React.createElement("use", {
      href: "#" + id + "__mask-background"
    }), Array.from({
      length: eraserPaths.length - i
    }, function(_2, j) {
      return j + i;
    }).map(function(k) {
      return React.createElement("use", {
        key: k.toString(),
        href: "#" + id + "__eraser-" + k.toString()
      });
    }));
  })), React.createElement("g", {
    id: id + "__canvas-background-group"
  }, React.createElement("rect", {
    id: id + "__canvas-background",
    x: "0",
    y: "0",
    width: "100%",
    height: "100%",
    fill: backgroundImage ? "url(#" + id + "__background)" : canvasColor
  })), pathGroups.map(function(pathGroup, i) {
    return React.createElement("g", {
      id: id + "__stroke-group-" + i,
      key: id + "__stroke-group-" + i,
      mask: "url(#" + id + "__eraser-mask-" + i + ")"
    }, React.createElement(Paths, {
      id,
      paths: pathGroup
    }));
  })));
});
var ReactSketchCanvas = React.forwardRef(function(props, ref) {
  var _props$id = props.id, id = _props$id === void 0 ? "react-sketch-canvas" : _props$id, _props$width = props.width, width = _props$width === void 0 ? "100%" : _props$width, _props$height = props.height, height = _props$height === void 0 ? "100%" : _props$height, _props$className = props.className, className = _props$className === void 0 ? "" : _props$className, _props$canvasColor = props.canvasColor, canvasColor = _props$canvasColor === void 0 ? "white" : _props$canvasColor, _props$strokeColor = props.strokeColor, strokeColor = _props$strokeColor === void 0 ? "red" : _props$strokeColor, _props$backgroundImag = props.backgroundImage, backgroundImage = _props$backgroundImag === void 0 ? "" : _props$backgroundImag, _props$exportWithBack = props.exportWithBackgroundImage, exportWithBackgroundImage = _props$exportWithBack === void 0 ? false : _props$exportWithBack, _props$preserveBackgr = props.preserveBackgroundImageAspectRatio, preserveBackgroundImageAspectRatio = _props$preserveBackgr === void 0 ? "none" : _props$preserveBackgr, _props$strokeWidth = props.strokeWidth, strokeWidth = _props$strokeWidth === void 0 ? 4 : _props$strokeWidth, _props$eraserWidth = props.eraserWidth, eraserWidth = _props$eraserWidth === void 0 ? 8 : _props$eraserWidth, _props$allowOnlyPoint = props.allowOnlyPointerType, allowOnlyPointerType = _props$allowOnlyPoint === void 0 ? "all" : _props$allowOnlyPoint, _props$style = props.style, style = _props$style === void 0 ? {
    border: "0.0625rem solid #9c9c9c",
    borderRadius: "0.25rem"
  } : _props$style, _props$svgStyle = props.svgStyle, svgStyle = _props$svgStyle === void 0 ? {} : _props$svgStyle, _props$onChange = props.onChange, onChange = _props$onChange === void 0 ? function(_paths) {
  } : _props$onChange, _props$onStroke = props.onStroke, onStroke = _props$onStroke === void 0 ? function(_path, _isEraser) {
  } : _props$onStroke, _props$withTimestamp = props.withTimestamp, withTimestamp = _props$withTimestamp === void 0 ? false : _props$withTimestamp;
  var svgCanvas = React.createRef();
  var _React$useState = React.useState(true), drawMode = _React$useState[0], setDrawMode = _React$useState[1];
  var _React$useState2 = React.useState(false), isDrawing = _React$useState2[0], setIsDrawing = _React$useState2[1];
  var _React$useState3 = React.useState([]), resetStack = _React$useState3[0], setResetStack = _React$useState3[1];
  var _React$useState4 = React.useState([]), undoStack = _React$useState4[0], setUndoStack = _React$useState4[1];
  var _React$useState5 = React.useState([]), currentPaths = _React$useState5[0], setCurrentPaths = _React$useState5[1];
  var liftStrokeUp = React.useCallback(function() {
    var _currentPaths$slice$, _currentPaths$slice;
    var lastStroke = (_currentPaths$slice$ = (_currentPaths$slice = currentPaths.slice(-1)) == null ? void 0 : _currentPaths$slice[0]) != null ? _currentPaths$slice$ : null;
    if (lastStroke === null) {
      console.warn("No stroke found!");
      return;
    }
    onStroke(lastStroke, !lastStroke.drawMode);
  }, [isDrawing]);
  React.useEffect(function() {
    liftStrokeUp();
  }, [isDrawing]);
  React.useEffect(function() {
    onChange(currentPaths);
  }, [currentPaths]);
  React.useImperativeHandle(ref, function() {
    return {
      eraseMode: function eraseMode(erase) {
        setDrawMode(!erase);
      },
      clearCanvas: function clearCanvas() {
        setResetStack([].concat(currentPaths));
        setCurrentPaths([]);
      },
      undo: function undo() {
        if (resetStack.length !== 0) {
          setCurrentPaths([].concat(resetStack));
          setResetStack([]);
          return;
        }
        setUndoStack(function(undoStack2) {
          return [].concat(undoStack2, currentPaths.slice(-1));
        });
        setCurrentPaths(function(currentPaths2) {
          return currentPaths2.slice(0, -1);
        });
      },
      redo: function redo() {
        if (undoStack.length === 0) return;
        setCurrentPaths(function(currentPaths2) {
          return [].concat(currentPaths2, undoStack.slice(-1));
        });
        setUndoStack(function(undoStack2) {
          return undoStack2.slice(0, -1);
        });
      },
      exportImage: function exportImage(imageType) {
        var _svgCanvas$current;
        var exportImage2 = (_svgCanvas$current = svgCanvas.current) == null ? void 0 : _svgCanvas$current.exportImage;
        if (!exportImage2) {
          throw Error("Export function called before canvas loaded");
        } else {
          return exportImage2(imageType);
        }
      },
      exportSvg: function exportSvg() {
        return new Promise(function(resolve, reject) {
          var _svgCanvas$current2;
          var exportSvg2 = (_svgCanvas$current2 = svgCanvas.current) == null ? void 0 : _svgCanvas$current2.exportSvg;
          if (!exportSvg2) {
            reject(Error("Export function called before canvas loaded"));
          } else {
            exportSvg2().then(function(data) {
              resolve(data);
            })["catch"](function(e) {
              reject(e);
            });
          }
        });
      },
      exportPaths: function exportPaths() {
        return new Promise(function(resolve, reject) {
          try {
            resolve(currentPaths);
          } catch (e) {
            reject(e);
          }
        });
      },
      loadPaths: function loadPaths(paths) {
        setCurrentPaths(function(currentPaths2) {
          return [].concat(currentPaths2, paths);
        });
      },
      getSketchingTime: function getSketchingTime() {
        return new Promise(function(resolve, reject) {
          if (!withTimestamp) {
            reject(new Error("Set 'withTimestamp' prop to get sketching time"));
          }
          try {
            var sketchingTime = currentPaths.reduce(function(totalSketchingTime, path) {
              var _path$startTimestamp, _path$endTimestamp;
              var startTimestamp = (_path$startTimestamp = path.startTimestamp) != null ? _path$startTimestamp : 0;
              var endTimestamp = (_path$endTimestamp = path.endTimestamp) != null ? _path$endTimestamp : 0;
              return totalSketchingTime + (endTimestamp - startTimestamp);
            }, 0);
            resolve(sketchingTime);
          } catch (e) {
            reject(e);
          }
        });
      },
      resetCanvas: function resetCanvas() {
        setResetStack([]);
        setUndoStack([]);
        setCurrentPaths([]);
      }
    };
  });
  var handlePointerDown = function handlePointerDown2(point) {
    setIsDrawing(true);
    setUndoStack([]);
    var stroke = {
      drawMode,
      strokeColor: drawMode ? strokeColor : "#000000",
      strokeWidth: drawMode ? strokeWidth : eraserWidth,
      paths: [point]
    };
    if (withTimestamp) {
      stroke = _extends({}, stroke, {
        startTimestamp: Date.now(),
        endTimestamp: 0
      });
    }
    setCurrentPaths(function(currentPaths2) {
      return [].concat(currentPaths2, [stroke]);
    });
  };
  var handlePointerMove = function handlePointerMove2(point) {
    if (!isDrawing) return;
    var currentStroke = currentPaths.slice(-1)[0];
    var updatedStroke = _extends({}, currentStroke, {
      paths: [].concat(currentStroke.paths, [point])
    });
    setCurrentPaths(function(currentPaths2) {
      return [].concat(currentPaths2.slice(0, -1), [updatedStroke]);
    });
  };
  var handlePointerUp = function handlePointerUp2() {
    var _currentPaths$slice$2, _currentPaths$slice2;
    if (!isDrawing) {
      return;
    }
    setIsDrawing(false);
    if (!withTimestamp) {
      return;
    }
    var currentStroke = (_currentPaths$slice$2 = (_currentPaths$slice2 = currentPaths.slice(-1)) == null ? void 0 : _currentPaths$slice2[0]) != null ? _currentPaths$slice$2 : null;
    if (currentStroke === null) {
      return;
    }
    var updatedStroke = _extends({}, currentStroke, {
      endTimestamp: Date.now()
    });
    setCurrentPaths(function(currentPaths2) {
      return [].concat(currentPaths2.slice(0, -1), [updatedStroke]);
    });
  };
  return React.createElement(Canvas, {
    ref: svgCanvas,
    id,
    width,
    height,
    className,
    canvasColor,
    backgroundImage,
    exportWithBackgroundImage,
    preserveBackgroundImageAspectRatio,
    allowOnlyPointerType,
    style,
    svgStyle,
    paths: currentPaths,
    isDrawing,
    onPointerDown: handlePointerDown,
    onPointerMove: handlePointerMove,
    onPointerUp: handlePointerUp
  });
});
export {
  Canvas,
  ReactSketchCanvas
};
//# sourceMappingURL=react-sketch-canvas.js.map
