# @zag-js/tour

Core logic for the tour widget implemented as a state machine

## Installation

```sh
yarn add @zag-js/tour
# or
npm i @zag-js/tour
```

## Contribution

Yes please! See the [contributing guidelines](https://github.com/chakra-ui/zag/blob/main/CONTRIBUTING.md) for details.

## Licence

This project is licensed under the terms of the [MIT license](https://github.com/chakra-ui/zag/blob/main/LICENSE).

### Docs Examples

Useful for designing guided product tours, feature highlights, contextual help in your application.

- https://design.mindsphere.io/patterns/guided-tour.html
- https://design.mindsphere.io/patterns/guided-tour.html
- https://codepen.io/collection/DyPkzY?cursor=eyJwYWdlIjoxfQ==

- Changing the placement of a tour, per step
- Exiting the tour on interaction outside
- Styling the overlay background
- Adding a stroke around around the overlay
- Highlighting with no target
- Showing tour progress
- Removing the overlay
- Disabling keyboard navigation
- Handling Cross frame elements (iframes)
- RTL Support (right to left)
- Customizing the accessibility labels
- Asynchronous steps using `effects`
  - Lazy-Loading
  - Show step after a delay
- Celebrating the end of the tour
  - End the tour with a celebration
- Wait for Navigation and Content to Load
- Accessibility
  - Keyboard navigation
  - Screen reader support
  - Focus management
  - Live region for content updates

### Pro Examples

- Customizable Tour Templates
- Analytics Integration
- Multi-Language Support
- Advanced Branching Logic
