import { MachineSchema, Machine, Service } from '@zag-js/core';
export { mergeProps } from '@zag-js/core';
import * as _zag_js_types from '@zag-js/types';
import { JSX, HTMLAttributes, CSSProperties, RefObject, PropsWithChildren } from 'react';

declare function useMachine<T extends MachineSchema>(machine: Machine<T>, userProps?: Partial<T["props"]>): Service<T>;

type WithoutRef<T> = Omit<T, "ref">;
type ElementsWithoutRef = {
    [K in keyof JSX.IntrinsicElements]: WithoutRef<JSX.IntrinsicElements[K]>;
};
type PropTypes = ElementsWithoutRef & {
    element: WithoutRef<HTMLAttributes<HTMLElement>>;
    style: CSSProperties;
};
declare const normalizeProps: _zag_js_types.NormalizeProps<PropTypes>;

interface PortalProps {
    disabled?: boolean;
    container?: RefObject<HTMLElement>;
    getRootNode?: () => ShadowRoot | Document | Node;
}
declare const Portal: (props: PropsWithChildren<PortalProps>) => JSX.Element;

export { Portal, type PortalProps, type PropTypes, normalizeProps, useMachine };
