import * as _zag_js_anatomy from '@zag-js/anatomy';
import { RequiredBy, DirectionProperty, CommonProperties, PropTypes, NormalizeProps } from '@zag-js/types';
import * as _zag_js_core from '@zag-js/core';
import { Service, EventObject, Machine } from '@zag-js/core';
import { DataUrlType } from '@zag-js/dom-query';
import { QrCodeGenerateOptions, QrCodeGenerateResult } from 'uqr';
export { QrCodeGenerateOptions, QrCodeGenerateResult } from 'uqr';

declare const anatomy: _zag_js_anatomy.AnatomyInstance<"root" | "frame" | "pattern" | "overlay" | "downloadTrigger">;

interface ValueChangeDetails {
    value: string;
}
type ElementIds = Partial<{
    root: string;
    frame: string;
}>;
interface QrCodeProps extends DirectionProperty, CommonProperties {
    /**
     * The controlled value to encode.
     */
    value?: string | undefined;
    /**
     * The initial value to encode when rendered.
     * Use when you don't need to control the value of the qr code.
     */
    defaultValue?: string | undefined;
    /**
     * The element ids.
     */
    ids?: ElementIds | undefined;
    /**
     * The qr code encoding options.
     */
    encoding?: QrCodeGenerateOptions | undefined;
    /**
     * Callback fired when the value changes.
     */
    onValueChange?: ((details: ValueChangeDetails) => void) | undefined;
    /**
     * The pixel size of the qr code.
     */
    pixelSize?: number | undefined;
}
type PropsWithDefault = "pixelSize" | "defaultValue";
type Computed = Readonly<{
    encoded: QrCodeGenerateResult;
}>;
interface QrCodeSchema {
    props: RequiredBy<QrCodeProps, PropsWithDefault>;
    context: {
        value: string;
    };
    computed: Computed;
    state: "idle";
    event: EventObject;
    action: string;
    effect: string;
    guard: string;
}
type QrCodeService = Service<QrCodeSchema>;
type QrCodeMachine = Machine<QrCodeSchema>;
interface DownloadTriggerProps {
    /**
     * The mime type of the image.
     */
    mimeType: DataUrlType;
    /**
     * The quality of the image.
     */
    quality?: number;
    /**
     * The name of the file.
     */
    fileName: string;
}
interface QrCodeApi<T extends PropTypes = PropTypes> {
    /**
     * The value to encode.
     */
    value: string;
    /**
     * Set the value to encode.
     */
    setValue(value: string): void;
    /**
     * Returns the data URL of the qr code.
     */
    getDataUrl(type: DataUrlType, quality?: number): Promise<string>;
    getRootProps(): T["element"];
    getFrameProps(): T["svg"];
    getPatternProps(): T["path"];
    getOverlayProps(): T["element"];
    getDownloadTriggerProps(props: DownloadTriggerProps): T["button"];
}

declare function connect<T extends PropTypes>(service: QrCodeService, normalize: NormalizeProps<T>): QrCodeApi<T>;

declare const machine: _zag_js_core.Machine<QrCodeSchema>;

declare const props: (keyof QrCodeProps)[];
declare const splitProps: <Props extends Partial<QrCodeProps>>(props: Props) => [Partial<QrCodeProps>, Omit<Props, keyof QrCodeProps>];

export { type QrCodeApi as Api, type DownloadTriggerProps, type ElementIds, type QrCodeMachine as Machine, type QrCodeProps as Props, type QrCodeService as Service, type ValueChangeDetails, anatomy, connect, machine, props, splitProps };
