import { InteractOutsideHandlers } from '@zag-js/dismissable';
export { FocusOutsideEvent, InteractOutsideEvent, PointerDownOutsideEvent } from '@zag-js/dismissable';
import * as _zag_js_anatomy from '@zag-js/anatomy';
import { RequiredBy, CommonProperties, DirectionProperty, Orientation, PropTypes, NormalizeProps } from '@zag-js/types';
import { ColorChannel, Color, ColorFormat, ColorAxes } from '@zag-js/color-utils';
export { Color, ColorAxes, ColorChannel, ColorFormat, ColorType } from '@zag-js/color-utils';
import * as _zag_js_core from '@zag-js/core';
import { Service, EventObject, Machine } from '@zag-js/core';
import { PositioningOptions } from '@zag-js/popper';
export { PositioningOptions } from '@zag-js/popper';

declare const anatomy: _zag_js_anatomy.Anatomy<"content" | "label" | "area" | "root" | "control" | "trigger" | "positioner" | "areaThumb" | "valueText" | "areaBackground" | "channelSlider" | "channelSliderLabel" | "channelSliderTrack" | "channelSliderThumb" | "channelSliderValueText" | "channelInput" | "transparencyGrid" | "swatchGroup" | "swatchTrigger" | "swatchIndicator" | "swatch" | "eyeDropperTrigger" | "formatTrigger" | "formatSelect">;

type ExtendedColorChannel = ColorChannel | "hex" | "css";
interface EyeDropper {
    new (): EyeDropper;
    open: (options?: {
        signal?: AbortSignal;
    }) => Promise<{
        sRGBHex: string;
    }>;
    [Symbol.toStringTag]: "EyeDropper";
}
declare global {
    interface Window {
        EyeDropper: EyeDropper;
    }
}
interface ValueChangeDetails {
    value: Color;
    valueAsString: string;
}
interface OpenChangeDetails {
    open: boolean;
}
interface FormatChangeDetails {
    format: ColorFormat;
}
type ElementIds = Partial<{
    root: string;
    control: string;
    trigger: string;
    label: string;
    input: string;
    hiddenInput: string;
    content: string;
    area: string;
    areaGradient: string;
    positioner: string;
    formatSelect: string;
    areaThumb: string;
    channelInput(id: string): string;
    channelSliderTrack(id: ColorChannel): string;
    channelSliderThumb(id: ColorChannel): string;
}>;
interface ColorPickerProps extends CommonProperties, DirectionProperty, InteractOutsideHandlers {
    /**
     * The ids of the elements in the color picker. Useful for composition.
     */
    ids?: ElementIds | undefined;
    /**
     * The controlled color value of the color picker
     */
    value?: Color | undefined;
    /**
     * The initial color value when rendered.
     * Use when you don't need to control the color value of the color picker.
     * @default #000000
     */
    defaultValue?: Color | undefined;
    /**
     * Whether the color picker is disabled
     */
    disabled?: boolean | undefined;
    /**
     * Whether the color picker is read-only
     */
    readOnly?: boolean | undefined;
    /**
     * Whether the color picker is required
     */
    required?: boolean | undefined;
    /**
     * Whether the color picker is invalid
     */
    invalid?: boolean | undefined;
    /**
     * Handler that is called when the value changes, as the user drags.
     */
    onValueChange?: ((details: ValueChangeDetails) => void) | undefined;
    /**
     * Handler that is called when the user stops dragging.
     */
    onValueChangeEnd?: ((details: ValueChangeDetails) => void) | undefined;
    /**
     * Handler that is called when the user opens or closes the color picker.
     */
    onOpenChange?: ((details: OpenChangeDetails) => void) | undefined;
    /**
     * The name for the form input
     */
    name?: string | undefined;
    /**
     * The positioning options for the color picker
     */
    positioning?: PositioningOptions | undefined;
    /**
     * The initial focus element when the color picker is opened.
     */
    initialFocusEl?: (() => HTMLElement | null) | undefined;
    /**
     * The controlled open state of the color picker
     */
    open?: boolean | undefined;
    /**
     * The initial open state of the color picker when rendered.
     * Use when you don't need to control the open state of the color picker.
     */
    defaultOpen?: boolean | undefined;
    /**
     * The controlled color format to use
     */
    format?: ColorFormat | undefined;
    /**
     * The initial color format when rendered.
     * Use when you don't need to control the color format of the color picker.
     * @default "rgba"
     */
    defaultFormat?: ColorFormat | undefined;
    /**
     * Function called when the color format changes
     */
    onFormatChange?: ((details: FormatChangeDetails) => void) | undefined;
    /**
     * Whether to close the color picker when a swatch is selected
     * @default false
     */
    closeOnSelect?: boolean | undefined;
    /**
     * Whether to auto focus the color picker when it is opened
     * @default true
     */
    openAutoFocus?: boolean | undefined;
}
type PropsWithDefault = "defaultFormat" | "defaultValue" | "openAutoFocus" | "dir" | "positioning";
type ColorPickerSchema = {
    tag: "open" | "closed" | "dragging" | "focused";
    state: "idle" | "focused" | "open" | "open:dragging";
    props: RequiredBy<ColorPickerProps, PropsWithDefault>;
    computed: {
        disabled: boolean;
        rtl: boolean;
        interactive: boolean;
        valueAsString: string;
        areaValue: Color;
    };
    context: {
        format: ColorFormat;
        value: Color;
        activeId: string | null;
        activeChannel: Partial<ColorAxes> | null;
        activeOrientation: Orientation | null;
        fieldsetDisabled: boolean;
        currentPlacement: PositioningOptions["placement"] | undefined;
        restoreFocus: boolean;
    };
    event: EventObject;
    action: string;
    effect: string;
    guard: string;
};
type ColorPickerService = Service<ColorPickerSchema>;
type ColorPickerMachine = Machine<ColorPickerSchema>;
interface ChannelProps {
    channel: ColorChannel;
    orientation?: Orientation | undefined;
}
interface ChannelSliderProps extends ChannelProps {
    format?: ColorFormat | undefined;
}
interface ChannelInputProps {
    channel: ExtendedColorChannel;
    orientation?: Orientation | undefined;
}
interface AreaProps {
    xChannel?: ColorChannel | undefined;
    yChannel?: ColorChannel | undefined;
}
interface SwatchTriggerProps {
    /**
     * The color value
     */
    value: string | Color;
    /**
     * Whether the swatch trigger is disabled
     */
    disabled?: boolean | undefined;
}
interface SwatchTriggerState {
    value: Color;
    valueAsString: string;
    checked: boolean;
    disabled: boolean;
}
interface SwatchProps {
    /**
     * The color value
     */
    value: string | Color;
    /**
     * Whether to include the alpha channel in the color
     */
    respectAlpha?: boolean | undefined;
}
interface TransparencyGridProps {
    size?: string | undefined;
}
interface ColorPickerApi<T extends PropTypes = PropTypes> {
    /**
     * Whether the color picker is being dragged
     */
    dragging: boolean;
    /**
     * Whether the color picker is open
     */
    open: boolean;
    /**
     * The current color value (as a string)
     */
    value: Color;
    /**
     * The current color value (as a Color object)
     */
    valueAsString: string;
    /**
     * Function to set the color value
     */
    setValue(value: string | Color): void;
    /**
     * Function to set the color value
     */
    getChannelValue(channel: ColorChannel): string;
    /**
     * Function to get the formatted and localized value of a specific channel
     */
    getChannelValueText(channel: ColorChannel, locale: string): string;
    /**
     * Function to set the color value of a specific channel
     */
    setChannelValue(channel: ColorChannel, value: number): void;
    /**
     * The current color format
     */
    format: ColorFormat;
    /**
     * Function to set the color format
     */
    setFormat(format: ColorFormat): void;
    /**
     * The alpha value of the color
     */
    alpha: number;
    /**
     * Function to set the color alpha
     */
    setAlpha(value: number): void;
    /**
     * Function to open or close the color picker
     */
    setOpen(open: boolean): void;
    getRootProps(): T["element"];
    getLabelProps(): T["element"];
    getControlProps(): T["element"];
    getTriggerProps(): T["button"];
    getPositionerProps(): T["element"];
    getContentProps(): T["element"];
    getHiddenInputProps(): T["input"];
    getValueTextProps(): T["element"];
    getAreaProps(props?: AreaProps): T["element"];
    getAreaBackgroundProps(props?: AreaProps): T["element"];
    getAreaThumbProps(props?: AreaProps): T["element"];
    getChannelInputProps(props: ChannelInputProps): T["input"];
    getChannelSliderProps(props: ChannelSliderProps): T["element"];
    getChannelSliderTrackProps(props: ChannelSliderProps): T["element"];
    getChannelSliderThumbProps(props: ChannelSliderProps): T["element"];
    getChannelSliderLabelProps(props: ChannelProps): T["element"];
    getChannelSliderValueTextProps(props: ChannelProps): T["element"];
    getTransparencyGridProps(props?: TransparencyGridProps): T["element"];
    getEyeDropperTriggerProps(): T["button"];
    getSwatchGroupProps(): T["element"];
    getSwatchTriggerProps(props: SwatchTriggerProps): T["button"];
    getSwatchTriggerState(props: SwatchTriggerProps): SwatchTriggerState;
    getSwatchProps(props: SwatchProps): T["element"];
    getSwatchIndicatorProps(props: SwatchProps): T["element"];
    getFormatSelectProps(): T["select"];
    getFormatTriggerProps(): T["button"];
}

declare function connect<T extends PropTypes>(service: ColorPickerService, normalize: NormalizeProps<T>): ColorPickerApi<T>;

declare const machine: _zag_js_core.Machine<ColorPickerSchema>;

declare const parse: (colorString: string) => Color;

declare const props: (keyof ColorPickerProps)[];
declare const splitProps: <Props extends Partial<ColorPickerProps>>(props: Props) => [Partial<ColorPickerProps>, Omit<Props, keyof ColorPickerProps>];
declare const areaProps: (keyof AreaProps)[];
declare const splitAreaProps: <Props extends AreaProps>(props: Props) => [AreaProps, Omit<Props, keyof AreaProps>];
declare const channelProps: (keyof ChannelProps)[];
declare const splitChannelProps: <Props extends ChannelProps>(props: Props) => [ChannelProps, Omit<Props, keyof ChannelProps>];
declare const swatchTriggerProps: (keyof SwatchTriggerProps)[];
declare const splitSwatchTriggerProps: <Props extends SwatchTriggerProps>(props: Props) => [SwatchTriggerProps, Omit<Props, keyof SwatchTriggerProps>];
declare const swatchProps: (keyof SwatchProps)[];
declare const splitSwatchProps: <Props extends SwatchProps>(props: Props) => [SwatchProps, Omit<Props, keyof SwatchProps>];
declare const transparencyGridProps: "size"[];
declare const splitTransparencyGridProps: <Props extends TransparencyGridProps>(props: Props) => [TransparencyGridProps, Omit<Props, "size">];

export { type ColorPickerApi as Api, type AreaProps, type ChannelInputProps, type ChannelProps, type ChannelSliderProps, type ElementIds, type FormatChangeDetails, type ColorPickerMachine as Machine, type OpenChangeDetails, type ColorPickerProps as Props, type ColorPickerService as Service, type SwatchProps, type SwatchTriggerProps, type SwatchTriggerState, type TransparencyGridProps, type ValueChangeDetails, anatomy, areaProps, channelProps, connect, machine, parse, props, splitAreaProps, splitChannelProps, splitProps, splitSwatchProps, splitSwatchTriggerProps, splitTransparencyGridProps, swatchProps, swatchTriggerProps, transparencyGridProps };
