export declare const slotRecipes: {
    accordion: import("..").SlotRecipeDefinition<"root" | "item" | "itemTrigger" | "itemContent" | "itemIndicator" | "itemBody", {
        variant: {
            outline: {
                item: {
                    borderBottomWidth: "1px";
                };
            };
            subtle: {
                itemTrigger: {
                    px: "var(--accordion-padding-x)";
                };
                itemContent: {
                    px: "var(--accordion-padding-x)";
                };
                item: {
                    borderRadius: "var(--accordion-radius)";
                    _open: {
                        bg: "colorPalette.subtle";
                    };
                };
            };
            enclosed: {
                root: {
                    borderWidth: "1px";
                    borderRadius: "var(--accordion-radius)";
                    divideY: string;
                    overflow: "hidden";
                };
                itemTrigger: {
                    px: "var(--accordion-padding-x)";
                };
                itemContent: {
                    px: "var(--accordion-padding-x)";
                };
                item: {
                    _open: {
                        bg: "bg.subtle";
                    };
                };
            };
            plain: {};
        };
        size: {
            sm: {
                root: {
                    "--accordion-padding-x": "spacing.3";
                    "--accordion-padding-y": "spacing.2";
                };
                itemTrigger: {
                    textStyle: "sm";
                    py: "var(--accordion-padding-y)";
                };
            };
            md: {
                root: {
                    "--accordion-padding-x": "spacing.4";
                    "--accordion-padding-y": "spacing.2";
                };
                itemTrigger: {
                    textStyle: "md";
                    py: "var(--accordion-padding-y)";
                };
            };
            lg: {
                root: {
                    "--accordion-padding-x": "spacing.4.5";
                    "--accordion-padding-y": "spacing.2.5";
                };
                itemTrigger: {
                    textStyle: "lg";
                    py: "var(--accordion-padding-y)";
                };
            };
        };
    }>;
    actionBar: import("..").SlotRecipeDefinition<"positioner" | "content" | "separator" | "selectionTrigger" | "closeTrigger", import("..").SlotRecipeVariantRecord<"positioner" | "content" | "separator" | "selectionTrigger" | "closeTrigger">>;
    alert: import("..").SlotRecipeDefinition<"root" | "content" | "title" | "description" | "indicator", {
        status: {
            info: {
                root: {
                    colorPalette: "blue";
                };
            };
            warning: {
                root: {
                    colorPalette: "orange";
                };
            };
            success: {
                root: {
                    colorPalette: "green";
                };
            };
            error: {
                root: {
                    colorPalette: "red";
                };
            };
            neutral: {
                root: {
                    colorPalette: "gray";
                };
            };
        };
        inline: {
            true: {
                content: {
                    display: "inline-flex";
                    flexDirection: "row";
                    alignItems: "center";
                };
            };
            false: {
                content: {
                    display: "flex";
                    flexDirection: "column";
                };
            };
        };
        variant: {
            subtle: {
                root: {
                    bg: "colorPalette.subtle";
                    color: "colorPalette.fg";
                };
            };
            surface: {
                root: {
                    bg: "colorPalette.subtle";
                    color: "colorPalette.fg";
                    shadow: "inset 0 0 0px 1px var(--shadow-color)";
                    shadowColor: "colorPalette.muted";
                };
                indicator: {
                    color: "colorPalette.fg";
                };
            };
            outline: {
                root: {
                    color: "colorPalette.fg";
                    shadow: "inset 0 0 0px 1px var(--shadow-color)";
                    shadowColor: "colorPalette.muted";
                };
                indicator: {
                    color: "colorPalette.fg";
                };
            };
            solid: {
                root: {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                };
                indicator: {
                    color: "colorPalette.contrast";
                };
            };
        };
        size: {
            sm: {
                root: {
                    gap: "2";
                    px: "3";
                    py: "3";
                    textStyle: "xs";
                };
                indicator: {
                    textStyle: "lg";
                };
            };
            md: {
                root: {
                    gap: "3";
                    px: "4";
                    py: "4";
                    textStyle: "sm";
                };
                indicator: {
                    textStyle: "xl";
                };
            };
            lg: {
                root: {
                    gap: "3";
                    px: "4";
                    py: "4";
                    textStyle: "md";
                };
                indicator: {
                    textStyle: "2xl";
                };
            };
        };
    }>;
    avatar: import("..").SlotRecipeDefinition<"root" | "image" | "fallback", {
        size: {
            full: {
                root: {
                    "--avatar-size": "100%";
                    "--avatar-font-size": "100%";
                };
            };
            "2xs": {
                root: {
                    "--avatar-font-size": "fontSizes.2xs";
                    "--avatar-size": "sizes.6";
                };
            };
            xs: {
                root: {
                    "--avatar-font-size": "fontSizes.xs";
                    "--avatar-size": "sizes.8";
                };
            };
            sm: {
                root: {
                    "--avatar-font-size": "fontSizes.sm";
                    "--avatar-size": "sizes.9";
                };
            };
            md: {
                root: {
                    "--avatar-font-size": "fontSizes.md";
                    "--avatar-size": "sizes.10";
                };
            };
            lg: {
                root: {
                    "--avatar-font-size": "fontSizes.md";
                    "--avatar-size": "sizes.11";
                };
            };
            xl: {
                root: {
                    "--avatar-font-size": "fontSizes.lg";
                    "--avatar-size": "sizes.12";
                };
            };
            "2xl": {
                root: {
                    "--avatar-font-size": "fontSizes.xl";
                    "--avatar-size": "sizes.16";
                };
            };
        };
        variant: {
            solid: {
                root: {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                };
            };
            subtle: {
                root: {
                    bg: "colorPalette.muted";
                    color: "colorPalette.fg";
                };
            };
            outline: {
                root: {
                    color: "colorPalette.fg";
                    borderWidth: "1px";
                    borderColor: "colorPalette.muted";
                };
            };
        };
        shape: {
            square: {};
            rounded: {
                root: {
                    "--avatar-radius": "radii.l3";
                };
            };
            full: {
                root: {
                    "--avatar-radius": "radii.full";
                };
            };
        };
        borderless: {
            true: {
                root: {
                    "&[data-group-item]": {
                        borderWidth: "0px";
                    };
                };
            };
        };
    }>;
    blockquote: import("..").SlotRecipeDefinition<"root" | "content" | "icon" | "caption", {
        justify: {
            start: {
                root: {
                    alignItems: "flex-start";
                    textAlign: "start";
                };
            };
            center: {
                root: {
                    alignItems: "center";
                    textAlign: "center";
                };
            };
            end: {
                root: {
                    alignItems: "flex-end";
                    textAlign: "end";
                };
            };
        };
        variant: {
            subtle: {
                root: {
                    paddingX: "5";
                    borderStartWidth: "4px";
                    borderStartColor: "colorPalette.muted";
                };
                icon: {
                    color: "colorPalette.fg";
                };
            };
            solid: {
                root: {
                    paddingX: "5";
                    borderStartWidth: "4px";
                    borderStartColor: "colorPalette.solid";
                };
                icon: {
                    color: "colorPalette.solid";
                };
            };
            plain: {
                root: {
                    paddingX: "5";
                };
                icon: {
                    color: "colorPalette.solid";
                };
            };
        };
    }>;
    breadcrumb: import("..").SlotRecipeDefinition<"root" | "item" | "separator" | "link" | "currentLink" | "list" | "ellipsis", {
        variant: {
            underline: {
                link: {
                    color: "colorPalette.fg";
                    textDecoration: "underline";
                    textUnderlineOffset: "0.2em";
                    textDecorationColor: "colorPalette.muted";
                };
                currentLink: {
                    color: "colorPalette.fg";
                };
            };
            plain: {
                link: {
                    color: "fg.muted";
                    _hover: {
                        color: "fg";
                    };
                };
                currentLink: {
                    color: "fg";
                };
            };
        };
        size: {
            sm: {
                list: {
                    gap: "1";
                    textStyle: "xs";
                };
            };
            md: {
                list: {
                    gap: "1.5";
                    textStyle: "sm";
                };
            };
            lg: {
                list: {
                    gap: "2";
                    textStyle: "md";
                };
            };
        };
    }>;
    card: import("..").SlotRecipeDefinition<"root" | "title" | "description" | "header" | "body" | "footer", {
        size: {
            sm: {
                root: {
                    "--card-padding": "spacing.4";
                };
                title: {
                    textStyle: "md";
                };
            };
            md: {
                root: {
                    "--card-padding": "spacing.6";
                };
                title: {
                    textStyle: "lg";
                };
            };
            lg: {
                root: {
                    "--card-padding": "spacing.7";
                };
                title: {
                    textStyle: "xl";
                };
            };
        };
        variant: {
            elevated: {
                root: {
                    bg: "bg.panel";
                    boxShadow: "md";
                };
            };
            outline: {
                root: {
                    bg: "bg.panel";
                    borderWidth: "1px";
                    borderColor: "border";
                };
            };
            subtle: {
                root: {
                    bg: "bg.muted";
                };
            };
        };
    }>;
    checkbox: import("..").SlotRecipeDefinition<"root" | "indicator" | "control" | "label" | "group", {
        size: {
            xs: {
                root: {
                    gap: "1.5";
                };
                label: {
                    textStyle: "xs";
                };
                control: {
                    boxSize: "3";
                } | undefined;
            };
            sm: {
                root: {
                    gap: "2";
                };
                label: {
                    textStyle: "sm";
                };
                control: {
                    boxSize: "4";
                } | undefined;
            };
            md: {
                root: {
                    gap: "2.5";
                };
                label: {
                    textStyle: "sm";
                };
                control: {
                    boxSize: "5";
                    p: "0.5";
                } | undefined;
            };
            lg: {
                root: {
                    gap: "3";
                };
                label: {
                    textStyle: "md";
                };
                control: {
                    boxSize: "6";
                    p: "0.5";
                } | undefined;
            };
        };
        variant: {
            outline: {
                control: {
                    borderColor: "border";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        color: "colorPalette.fg";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            solid: {
                control: {
                    borderColor: "border";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            subtle: {
                control: {
                    bg: "colorPalette.muted";
                    borderColor: "colorPalette.muted";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        color: "colorPalette.fg";
                    };
                } | undefined;
            };
        };
    }>;
    checkboxCard: import("..").SlotRecipeDefinition<"root" | "content" | "description" | "indicator" | "control" | "label" | "addon", {
        size: {
            sm: {
                root: {
                    textStyle: "sm";
                };
                control: {
                    padding: "3";
                    gap: "1.5";
                };
                addon: {
                    px: "3";
                    py: "1.5";
                    borderTopWidth: "1px";
                };
                indicator: {
                    boxSize: "4";
                } | undefined;
            };
            md: {
                root: {
                    textStyle: "sm";
                };
                control: {
                    padding: "4";
                    gap: "2.5";
                };
                addon: {
                    px: "4";
                    py: "2";
                    borderTopWidth: "1px";
                };
                indicator: {
                    boxSize: "5";
                    p: "0.5";
                } | undefined;
            };
            lg: {
                root: {
                    textStyle: "md";
                };
                control: {
                    padding: "4";
                    gap: "3.5";
                };
                addon: {
                    px: "4";
                    py: "2";
                    borderTopWidth: "1px";
                };
                indicator: {
                    boxSize: "6";
                    p: "0.5";
                } | undefined;
            };
        };
        variant: {
            surface: {
                root: {
                    borderWidth: "1px";
                    borderColor: "border";
                    _checked: {
                        bg: "colorPalette.subtle";
                        color: "colorPalette.fg";
                        borderColor: "colorPalette.muted";
                    };
                    _disabled: {
                        bg: "bg.muted";
                    };
                };
                indicator: {
                    borderColor: "border";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            subtle: {
                root: {
                    bg: "bg.muted";
                };
                control: {
                    _checked: {
                        bg: "colorPalette.muted";
                        color: "colorPalette.fg";
                    };
                };
                indicator: {
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        color: "colorPalette.fg";
                    };
                } | undefined;
            };
            outline: {
                root: {
                    borderWidth: "1px";
                    borderColor: "border";
                    _checked: {
                        boxShadow: "0 0 0 1px var(--shadow-color)";
                        boxShadowColor: "colorPalette.solid";
                        borderColor: "colorPalette.solid";
                    };
                };
                indicator: {
                    borderColor: "border";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            solid: {
                root: {
                    borderWidth: "1px";
                    _checked: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                };
                indicator: {
                    borderColor: "border";
                    color: "colorPalette.fg";
                    "&:is([data-state=checked], [data-state=indeterminate])": {
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
        };
        justify: {
            start: {
                root: {
                    "--checkbox-card-justify": "flex-start";
                };
            };
            end: {
                root: {
                    "--checkbox-card-justify": "flex-end";
                };
            };
            center: {
                root: {
                    "--checkbox-card-justify": "center";
                };
            };
        };
        align: {
            start: {
                root: {
                    "--checkbox-card-align": "flex-start";
                };
                content: {
                    textAlign: "start";
                };
            };
            end: {
                root: {
                    "--checkbox-card-align": "flex-end";
                };
                content: {
                    textAlign: "end";
                };
            };
            center: {
                root: {
                    "--checkbox-card-align": "center";
                };
                content: {
                    textAlign: "center";
                };
            };
        };
        orientation: {
            vertical: {
                control: {
                    flexDirection: "column";
                };
            };
            horizontal: {
                control: {
                    flexDirection: "row";
                };
            };
        };
    }>;
    collapsible: import("..").SlotRecipeDefinition<"root" | "content" | "indicator" | "trigger", import("..").SlotRecipeVariantRecord<"root" | "content" | "indicator" | "trigger">>;
    dataList: import("..").SlotRecipeDefinition<"root" | "item" | "itemLabel" | "itemValue", {
        orientation: {
            horizontal: {
                root: {
                    display: "flex";
                    flexDirection: "column";
                };
                item: {
                    display: "inline-flex";
                    alignItems: "center";
                    gap: "4";
                };
                itemLabel: {
                    minWidth: "120px";
                };
            };
            vertical: {
                root: {
                    display: "flex";
                    flexDirection: "column";
                };
                item: {
                    display: "flex";
                    flexDirection: "column";
                    gap: "1";
                };
            };
        };
        size: {
            sm: {
                root: {
                    gap: "3";
                };
                item: {
                    textStyle: "xs";
                };
            };
            md: {
                root: {
                    gap: "4";
                };
                item: {
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    gap: "5";
                };
                item: {
                    textStyle: "md";
                };
            };
        };
        variant: {
            subtle: {
                itemLabel: {
                    color: "fg.muted";
                };
            };
            bold: {
                itemLabel: {
                    fontWeight: "medium";
                };
                itemValue: {
                    color: "fg.muted";
                };
            };
        };
    }>;
    dialog: import("..").SlotRecipeDefinition<"positioner" | "content" | "closeTrigger" | "title" | "description" | "header" | "body" | "footer" | "trigger" | "backdrop", {
        placement: {
            center: {
                positioner: {
                    alignItems: "center";
                };
                content: {
                    "--dialog-base-margin": "auto";
                    mx: "auto";
                };
            };
            top: {
                positioner: {
                    alignItems: "flex-start";
                };
                content: {
                    "--dialog-base-margin": "spacing.16";
                    mx: "auto";
                };
            };
            bottom: {
                positioner: {
                    alignItems: "flex-end";
                };
                content: {
                    "--dialog-base-margin": "spacing.16";
                    mx: "auto";
                };
            };
        };
        scrollBehavior: {
            inside: {
                positioner: {
                    overflow: "hidden";
                };
                content: {
                    maxH: "calc(100% - 7.5rem)";
                };
                body: {
                    overflow: "auto";
                };
            };
            outside: {
                positioner: {
                    overflow: "auto";
                    pointerEvents: "auto";
                };
            };
        };
        size: {
            xs: {
                content: {
                    maxW: "sm";
                };
            };
            sm: {
                content: {
                    maxW: "md";
                };
            };
            md: {
                content: {
                    maxW: "lg";
                };
            };
            lg: {
                content: {
                    maxW: "2xl";
                };
            };
            xl: {
                content: {
                    maxW: "4xl";
                };
            };
            cover: {
                positioner: {
                    padding: "10";
                };
                content: {
                    width: "100%";
                    height: "100%";
                    "--dialog-margin": "0";
                };
            };
            full: {
                content: {
                    maxW: "100vw";
                    minH: "100vh";
                    "--dialog-margin": "0";
                    borderRadius: "0";
                };
            };
        };
        motionPreset: {
            scale: {
                content: {
                    _open: {
                        animationName: "scale-in, fade-in";
                    };
                    _closed: {
                        animationName: "scale-out, fade-out";
                    };
                };
            };
            "slide-in-bottom": {
                content: {
                    _open: {
                        animationName: "slide-from-bottom, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-bottom, fade-out";
                    };
                };
            };
            "slide-in-top": {
                content: {
                    _open: {
                        animationName: "slide-from-top, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-top, fade-out";
                    };
                };
            };
            "slide-in-left": {
                content: {
                    _open: {
                        animationName: "slide-from-left, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-left, fade-out";
                    };
                };
            };
            "slide-in-right": {
                content: {
                    _open: {
                        animationName: "slide-from-right, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-right, fade-out";
                    };
                };
            };
            none: {};
        };
    }>;
    drawer: import("..").SlotRecipeDefinition<"positioner" | "content" | "closeTrigger" | "title" | "description" | "header" | "body" | "footer" | "trigger" | "backdrop", {
        size: {
            xs: {
                content: {
                    maxW: "xs";
                };
            };
            sm: {
                content: {
                    maxW: "md";
                };
            };
            md: {
                content: {
                    maxW: "lg";
                };
            };
            lg: {
                content: {
                    maxW: "2xl";
                };
            };
            xl: {
                content: {
                    maxW: "4xl";
                };
            };
            full: {
                content: {
                    maxW: "100vw";
                    h: "100dvh";
                };
            };
        };
        placement: {
            start: {
                positioner: {
                    justifyContent: "flex-start";
                };
                content: {
                    _open: {
                        animationName: {
                            base: "slide-from-left-full, fade-in";
                            _rtl: "slide-from-right-full, fade-in";
                        };
                    };
                    _closed: {
                        animationName: {
                            base: "slide-to-left-full, fade-out";
                            _rtl: "slide-to-right-full, fade-out";
                        };
                    };
                };
            };
            end: {
                positioner: {
                    justifyContent: "flex-end";
                };
                content: {
                    _open: {
                        animationName: {
                            base: "slide-from-right-full, fade-in";
                            _rtl: "slide-from-left-full, fade-in";
                        };
                    };
                    _closed: {
                        animationName: {
                            base: "slide-to-right-full, fade-out";
                            _rtl: "slide-to-right-full, fade-out";
                        };
                    };
                };
            };
            top: {
                positioner: {
                    alignItems: "flex-start";
                };
                content: {
                    maxW: "100%";
                    _open: {
                        animationName: "slide-from-top-full, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-top-full, fade-out";
                    };
                };
            };
            bottom: {
                positioner: {
                    alignItems: "flex-end";
                };
                content: {
                    maxW: "100%";
                    _open: {
                        animationName: "slide-from-bottom-full, fade-in";
                    };
                    _closed: {
                        animationName: "slide-to-bottom-full, fade-out";
                    };
                };
            };
        };
        contained: {
            true: {
                positioner: {
                    padding: "4";
                };
                content: {
                    borderRadius: "l3";
                };
            };
        };
    }>;
    editable: import("..").SlotRecipeDefinition<"root" | "control" | "label" | "input" | "area" | "preview" | "editTrigger" | "submitTrigger" | "cancelTrigger" | "textarea", {
        size: {
            sm: {
                root: {
                    textStyle: "sm";
                };
                preview: {
                    minH: "8";
                };
                input: {
                    minH: "8";
                };
            };
            md: {
                root: {
                    textStyle: "sm";
                };
                preview: {
                    minH: "9";
                };
                input: {
                    minH: "9";
                };
            };
            lg: {
                root: {
                    textStyle: "md";
                };
                preview: {
                    minH: "10";
                };
                input: {
                    minH: "10";
                };
            };
        };
    }>;
    emptyState: import("..").SlotRecipeDefinition<"root" | "content" | "title" | "description" | "indicator", {
        size: {
            sm: {
                root: {
                    px: "4";
                    py: "6";
                };
                title: {
                    textStyle: "md";
                };
                content: {
                    gap: "4";
                };
                indicator: {
                    textStyle: "2xl";
                };
            };
            md: {
                root: {
                    px: "8";
                    py: "12";
                };
                title: {
                    textStyle: "lg";
                };
                content: {
                    gap: "6";
                };
                indicator: {
                    textStyle: "4xl";
                };
            };
            lg: {
                root: {
                    px: "12";
                    py: "16";
                };
                title: {
                    textStyle: "xl";
                };
                content: {
                    gap: "8";
                };
                indicator: {
                    textStyle: "6xl";
                };
            };
        };
    }>;
    field: import("..").SlotRecipeDefinition<"root" | "label" | "input" | "textarea" | "select" | "errorText" | "helperText" | "requiredIndicator", {
        orientation: {
            vertical: {
                root: {
                    flexDirection: "column";
                    alignItems: "flex-start";
                };
            };
            horizontal: {
                root: {
                    flexDirection: "row";
                    alignItems: "center";
                    justifyContent: "space-between";
                };
                label: {
                    flex: "0 0 var(--field-label-width, 80px)";
                };
            };
        };
    }>;
    fieldset: import("..").SlotRecipeDefinition<"root" | "content" | "errorText" | "helperText" | "legend", {
        size: {
            sm: {
                root: {
                    spaceY: "2";
                };
                content: {
                    gap: "1.5";
                };
                legend: {
                    textStyle: "sm";
                };
            };
            md: {
                root: {
                    spaceY: "4";
                };
                content: {
                    gap: "4";
                };
                legend: {
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    spaceY: "6";
                };
                content: {
                    gap: "4";
                };
                legend: {
                    textStyle: "md";
                };
            };
        };
    }>;
    fileUpload: import("..").SlotRecipeDefinition<"root" | "item" | "itemContent" | "label" | "trigger" | "dropzone" | "itemDeleteTrigger" | "itemGroup" | "itemName" | "itemPreview" | "itemPreviewImage" | "itemSizeText" | "clearTrigger" | "dropzoneContent" | "fileText", import("..").SlotRecipeVariantRecord<"root" | "item" | "itemContent" | "label" | "trigger" | "dropzone" | "itemDeleteTrigger" | "itemGroup" | "itemName" | "itemPreview" | "itemPreviewImage" | "itemSizeText" | "clearTrigger" | "dropzoneContent" | "fileText">>;
    hoverCard: import("..").SlotRecipeDefinition<"positioner" | "content" | "trigger" | "arrow" | "arrowTip", {
        size: {
            xs: {
                content: {
                    padding: "3";
                };
            };
            sm: {
                content: {
                    padding: "4";
                };
            };
            md: {
                content: {
                    padding: "5";
                };
            };
            lg: {
                content: {
                    padding: "6";
                };
            };
        };
    }>;
    list: import("..").SlotRecipeDefinition<"root" | "item" | "indicator", {
        variant: {
            marker: {
                root: {
                    listStyle: "revert";
                };
                item: {
                    _marker: {
                        color: "fg.subtle";
                    };
                };
            };
            plain: {
                item: {
                    alignItems: "flex-start";
                    display: "inline-flex";
                };
            };
        };
        align: {
            center: {
                item: {
                    alignItems: "center";
                };
            };
            start: {
                item: {
                    alignItems: "flex-start";
                };
            };
            end: {
                item: {
                    alignItems: "flex-end";
                };
            };
        };
    }>;
    menu: import("..").SlotRecipeDefinition<"item" | "itemIndicator" | "positioner" | "content" | "separator" | "indicator" | "trigger" | "itemGroup" | "arrow" | "arrowTip" | "contextTrigger" | "itemGroupLabel" | "itemText" | "triggerItem" | "itemCommand", {
        variant: {
            subtle: {
                item: {
                    _highlighted: {
                        bg: "bg.emphasized/60";
                    };
                };
            };
            solid: {
                item: {
                    _highlighted: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                    };
                };
            };
        };
        size: {
            sm: {
                content: {
                    minW: "8rem";
                    padding: "1";
                };
                item: {
                    gap: "1";
                    textStyle: "xs";
                    py: "1";
                    px: "1.5";
                };
            };
            md: {
                content: {
                    minW: "8rem";
                    padding: "1.5";
                };
                item: {
                    gap: "2";
                    textStyle: "sm";
                    py: "1.5";
                    px: "2";
                };
            };
        };
    }>;
    nativeSelect: import("..").SlotRecipeDefinition<"root" | "indicator" | "field", {
        variant: {
            outline: {
                field: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    _expanded: {
                        borderColor: "border.emphasized";
                    };
                } | undefined;
            };
            subtle: {
                field: {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                } | undefined;
            };
            plain: {
                field: {
                    bg: "transparent";
                    color: "fg";
                    focusRingWidth: "2px";
                };
            };
        };
        size: {
            xs: {
                field: {
                    textStyle: "xs";
                    ps: "2";
                    pe: "6";
                    height: "6";
                };
                indicator: {
                    textStyle: "sm";
                    insetEnd: "1.5";
                };
            };
            sm: {
                field: {
                    textStyle: "sm";
                    ps: "2.5";
                    pe: "8";
                    height: "8";
                };
                indicator: {
                    textStyle: "md";
                    insetEnd: "2";
                };
            };
            md: {
                field: {
                    textStyle: "sm";
                    ps: "3";
                    pe: "8";
                    height: "10";
                };
                indicator: {
                    textStyle: "lg";
                    insetEnd: "2";
                };
            };
            lg: {
                field: {
                    textStyle: "md";
                    ps: "4";
                    pe: "8";
                    height: "11";
                };
                indicator: {
                    textStyle: "xl";
                    insetEnd: "3";
                };
            };
            xl: {
                field: {
                    textStyle: "md";
                    ps: "4.5";
                    pe: "10";
                    height: "12";
                };
                indicator: {
                    textStyle: "xl";
                    insetEnd: "3";
                };
            };
        };
    }>;
    numberInput: import("..").SlotRecipeDefinition<"root" | "control" | "label" | "input" | "valueText" | "incrementTrigger" | "decrementTrigger" | "scrubber", {
        size: {
            xs: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                };
                control: {
                    fontSize: "2xs";
                    "--stepper-width": "sizes.4";
                };
            };
            sm: {
                input: {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                };
                control: {
                    fontSize: "xs";
                    "--stepper-width": "sizes.5";
                };
            };
            md: {
                input: {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                };
                control: {
                    fontSize: "sm";
                    "--stepper-width": "sizes.6";
                };
            };
            lg: {
                input: {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                };
                control: {
                    fontSize: "sm";
                    "--stepper-width": "sizes.6";
                };
            };
        };
        variant: {
            outline: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
            subtle: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
            flushed: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
        };
    }>;
    pinInput: import("..").SlotRecipeDefinition<"root" | "control" | "label" | "input", {
        size: {
            sm: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            md: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            lg: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            xl: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            "2xl": {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            xs: {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
            "2xs": {
                input: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                };
            };
        };
        variant: {
            outline: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
            subtle: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
            flushed: {
                input: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | {
                    bg: "transparent";
                    borderBottomWidth: "1px";
                    borderBottomColor: "border";
                    borderRadius: "0";
                    px: "0";
                    _focusVisible: {
                        borderColor: "var(--focus-color)";
                        boxShadow: "0px 1px 0px 0px var(--focus-color)";
                    };
                };
            };
        };
        attached: {
            true: {
                control: {
                    gap: "0";
                    spaceX: "-1px";
                };
                input: {
                    _notFirst: {
                        borderStartRadius: "0";
                    };
                    _notLast: {
                        borderEndRadius: "0";
                    };
                    _focusVisible: {
                        zIndex: "1";
                    };
                };
            };
        };
    }>;
    popover: import("..").SlotRecipeDefinition<"positioner" | "content" | "closeTrigger" | "title" | "description" | "indicator" | "header" | "body" | "footer" | "trigger" | "arrow" | "arrowTip" | "anchor", {
        size: {
            xs: {
                content: {
                    "--popover-padding": "spacing.3";
                };
            };
            sm: {
                content: {
                    "--popover-padding": "spacing.4";
                };
            };
            md: {
                content: {
                    "--popover-padding": "spacing.5";
                };
            };
            lg: {
                content: {
                    "--popover-padding": "spacing.6";
                };
            };
        };
    }>;
    progress: import("..").SlotRecipeDefinition<"root" | "label" | "valueText" | "track" | "range" | "view" | "circle" | "circleTrack" | "circleRange", {
        variant: {
            outline: {
                track: {
                    shadow: "inset";
                    bgColor: "bg.muted";
                };
                range: {
                    bgColor: "colorPalette.solid";
                };
            };
            subtle: {
                track: {
                    bgColor: "colorPalette.muted";
                };
                range: {
                    bgColor: "colorPalette.solid/72";
                };
            };
        };
        shape: {
            square: {};
            rounded: {
                track: {
                    borderRadius: "l1";
                };
            };
            full: {
                track: {
                    borderRadius: "full";
                };
            };
        };
        striped: {
            true: {
                range: {
                    backgroundImage: "linear-gradient(45deg, var(--stripe-color) 25%, transparent 25%, transparent 50%, var(--stripe-color) 50%, var(--stripe-color) 75%, transparent 75%, transparent)";
                    backgroundSize: "var(--stripe-size) var(--stripe-size)";
                    "--stripe-size": "1rem";
                    "--stripe-color": {
                        _light: "rgba(255, 255, 255, 0.3)";
                        _dark: "rgba(0, 0, 0, 0.3)";
                    };
                };
            };
        };
        animated: {
            true: {
                range: {
                    "--animate-from": "var(--stripe-size)";
                    animation: "bg-position 1s linear infinite";
                };
            };
        };
        size: {
            xs: {
                track: {
                    h: "1.5";
                };
            };
            sm: {
                track: {
                    h: "2";
                };
            };
            md: {
                track: {
                    h: "2.5";
                };
            };
            lg: {
                track: {
                    h: "3";
                };
            };
            xl: {
                track: {
                    h: "4";
                };
            };
        };
    }>;
    progressCircle: import("..").SlotRecipeDefinition<"root" | "label" | "valueText" | "track" | "range" | "view" | "circle" | "circleTrack" | "circleRange", {
        size: {
            xs: {
                circle: {
                    "--size": "24px";
                    "--thickness": "4px";
                };
                valueText: {
                    textStyle: "2xs";
                };
            };
            sm: {
                circle: {
                    "--size": "32px";
                    "--thickness": "5px";
                };
                valueText: {
                    textStyle: "2xs";
                };
            };
            md: {
                circle: {
                    "--size": "40px";
                    "--thickness": "6px";
                };
                valueText: {
                    textStyle: "xs";
                };
            };
            lg: {
                circle: {
                    "--size": "48px";
                    "--thickness": "7px";
                };
                valueText: {
                    textStyle: "sm";
                };
            };
            xl: {
                circle: {
                    "--size": "64px";
                    "--thickness": "8px";
                };
                valueText: {
                    textStyle: "sm";
                };
            };
        };
    }>;
    radioCard: import("..").SlotRecipeDefinition<"root" | "item" | "itemContent" | "itemIndicator" | "indicator" | "label" | "itemText" | "itemControl" | "itemAddon" | "itemDescription", {
        size: {
            sm: {
                item: {
                    textStyle: "sm";
                };
                itemControl: {
                    padding: "3";
                    gap: "1.5";
                };
                itemAddon: {
                    px: "3";
                    py: "1.5";
                    borderTopWidth: "1px";
                };
                itemIndicator: {
                    boxSize: "4";
                } | undefined;
            };
            md: {
                item: {
                    textStyle: "sm";
                };
                itemControl: {
                    padding: "4";
                    gap: "2.5";
                };
                itemAddon: {
                    px: "4";
                    py: "2";
                    borderTopWidth: "1px";
                };
                itemIndicator: {
                    boxSize: "5";
                } | undefined;
            };
            lg: {
                item: {
                    textStyle: "md";
                };
                itemControl: {
                    padding: "4";
                    gap: "3.5";
                };
                itemAddon: {
                    px: "4";
                    py: "2";
                    borderTopWidth: "1px";
                };
                itemIndicator: {
                    boxSize: "6";
                } | undefined;
            };
        };
        variant: {
            surface: {
                item: {
                    borderWidth: "1px";
                    _checked: {
                        bg: "colorPalette.subtle";
                        color: "colorPalette.fg";
                        borderColor: "colorPalette.muted";
                    };
                };
                itemIndicator: {
                    borderWidth: "1px";
                    borderColor: "border";
                    _checked: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            subtle: {
                item: {
                    bg: "bg.muted";
                };
                itemControl: {
                    _checked: {
                        bg: "colorPalette.muted";
                        color: "colorPalette.fg";
                    };
                };
                itemIndicator: {
                    borderWidth: "1px";
                    borderColor: "inherit";
                    _checked: {
                        color: "colorPalette.fg";
                        borderColor: "colorPalette.solid";
                    };
                    "& .dot": {
                        scale: "0.6";
                    };
                } | undefined;
            };
            outline: {
                item: {
                    borderWidth: "1px";
                    _checked: {
                        boxShadow: "0 0 0 1px var(--shadow-color)";
                        boxShadowColor: "colorPalette.solid";
                        borderColor: "colorPalette.solid";
                    };
                };
                itemIndicator: {
                    borderWidth: "1px";
                    borderColor: "border";
                    _checked: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
            solid: {
                item: {
                    borderWidth: "1px";
                    _checked: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                };
                itemIndicator: {
                    bg: "bg";
                    borderWidth: "1px";
                    borderColor: "inherit";
                    _checked: {
                        color: "colorPalette.solid";
                        borderColor: "currentcolor";
                    };
                } | undefined;
            };
        };
        justify: {
            start: {
                item: {
                    "--radio-card-justify": "flex-start";
                };
            };
            end: {
                item: {
                    "--radio-card-justify": "flex-end";
                };
            };
            center: {
                item: {
                    "--radio-card-justify": "center";
                };
            };
        };
        align: {
            start: {
                item: {
                    "--radio-card-align": "flex-start";
                };
                itemControl: {
                    textAlign: "start";
                };
            };
            end: {
                item: {
                    "--radio-card-align": "flex-end";
                };
                itemControl: {
                    textAlign: "end";
                };
            };
            center: {
                item: {
                    "--radio-card-align": "center";
                };
                itemControl: {
                    textAlign: "center";
                };
            };
        };
        orientation: {
            vertical: {
                itemControl: {
                    flexDirection: "column";
                };
            };
            horizontal: {
                itemControl: {
                    flexDirection: "row";
                };
            };
        };
    }>;
    radioGroup: import("..").SlotRecipeDefinition<"root" | "item" | "itemIndicator" | "indicator" | "label" | "itemText" | "itemControl" | "itemAddon", {
        variant: {
            outline: {
                itemControl: {
                    borderWidth: "1px";
                    borderColor: "inherit";
                    _checked: {
                        color: "colorPalette.fg";
                        borderColor: "colorPalette.solid";
                    };
                    "& .dot": {
                        scale: "0.6";
                    };
                } | undefined;
            };
            subtle: {
                itemControl: {
                    borderWidth: "1px";
                    bg: "colorPalette.muted";
                    borderColor: "colorPalette.muted";
                    color: "transparent";
                    _checked: {
                        color: "colorPalette.fg";
                    };
                } | undefined;
            };
            solid: {
                itemControl: {
                    borderWidth: "1px";
                    borderColor: "border";
                    _checked: {
                        bg: "colorPalette.solid";
                        color: "colorPalette.contrast";
                        borderColor: "colorPalette.solid";
                    };
                } | undefined;
            };
        };
        size: {
            xs: {
                item: {
                    textStyle: "xs";
                    gap: "1.5";
                };
                itemControl: {
                    boxSize: "3";
                } | undefined;
            };
            sm: {
                item: {
                    textStyle: "sm";
                    gap: "2";
                };
                itemControl: {
                    boxSize: "4";
                } | undefined;
            };
            md: {
                item: {
                    textStyle: "sm";
                    gap: "2.5";
                };
                itemControl: {
                    boxSize: "5";
                } | undefined;
            };
            lg: {
                item: {
                    textStyle: "md";
                    gap: "3";
                };
                itemControl: {
                    boxSize: "6";
                } | undefined;
            };
        };
    }>;
    ratingGroup: import("..").SlotRecipeDefinition<"root" | "item" | "itemIndicator" | "control" | "label", {
        size: {
            xs: {
                item: {
                    textStyle: "sm";
                };
            };
            sm: {
                item: {
                    textStyle: "md";
                };
            };
            md: {
                item: {
                    textStyle: "xl";
                };
            };
            lg: {
                item: {
                    textStyle: "2xl";
                };
            };
        };
    }>;
    segmentGroup: import("..").SlotRecipeDefinition<"root" | "item" | "indicator" | "label" | "itemText" | "itemControl", {
        size: {
            xs: {
                item: {
                    textStyle: "xs";
                    px: "3";
                    gap: "1";
                    height: "6";
                };
            };
            sm: {
                item: {
                    textStyle: "sm";
                    px: "4";
                    gap: "2";
                    height: "8";
                };
            };
            md: {
                item: {
                    textStyle: "sm";
                    px: "4";
                    gap: "2";
                    height: "10";
                };
            };
            lg: {
                item: {
                    textStyle: "md";
                    px: "4.5";
                    gap: "3";
                    height: "11";
                };
            };
        };
    }>;
    select: import("..").SlotRecipeDefinition<"root" | "item" | "itemIndicator" | "positioner" | "content" | "indicator" | "list" | "control" | "label" | "trigger" | "itemGroup" | "clearTrigger" | "itemGroupLabel" | "itemText" | "valueText" | "indicatorGroup", {
        variant: {
            outline: {
                trigger: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    _expanded: {
                        borderColor: "border.emphasized";
                    };
                };
            };
            subtle: {
                trigger: {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                };
            };
        };
        size: {
            xs: {
                root: {
                    "--select-trigger-height": "sizes.8";
                    "--select-trigger-padding-x": "spacing.2";
                };
                content: {
                    p: "1";
                    gap: "1";
                    textStyle: "xs";
                };
                trigger: {
                    textStyle: "xs";
                    gap: "1";
                };
                item: {
                    py: "1";
                    px: "2";
                };
                itemGroupLabel: {
                    py: "1";
                    px: "2";
                };
                indicator: {
                    _icon: {
                        width: "3.5";
                        height: "3.5";
                    };
                };
            };
            sm: {
                root: {
                    "--select-trigger-height": "sizes.9";
                    "--select-trigger-padding-x": "spacing.2.5";
                };
                content: {
                    p: "1";
                    textStyle: "sm";
                };
                trigger: {
                    textStyle: "sm";
                    gap: "1";
                };
                indicator: {
                    _icon: {
                        width: "4";
                        height: "4";
                    };
                };
                item: {
                    py: "1";
                    px: "1.5";
                };
                itemGroup: {
                    mt: "1";
                };
                itemGroupLabel: {
                    py: "1";
                    px: "1.5";
                };
            };
            md: {
                root: {
                    "--select-trigger-height": "sizes.10";
                    "--select-trigger-padding-x": "spacing.3";
                };
                content: {
                    p: "1";
                    textStyle: "sm";
                };
                itemGroup: {
                    mt: "1.5";
                };
                item: {
                    py: "1.5";
                    px: "2";
                };
                itemIndicator: {
                    display: "flex";
                    alignItems: "center";
                    justifyContent: "center";
                };
                itemGroupLabel: {
                    py: "1.5";
                    px: "2";
                };
                trigger: {
                    textStyle: "sm";
                    gap: "2";
                };
                indicator: {
                    _icon: {
                        width: "4";
                        height: "4";
                    };
                };
            };
            lg: {
                root: {
                    "--select-trigger-height": "sizes.12";
                    "--select-trigger-padding-x": "spacing.4";
                };
                content: {
                    p: "1.5";
                    textStyle: "md";
                };
                itemGroup: {
                    mt: "2";
                };
                item: {
                    py: "2";
                    px: "3";
                };
                itemGroupLabel: {
                    py: "2";
                    px: "3";
                };
                trigger: {
                    textStyle: "md";
                    py: "3";
                    gap: "2";
                };
                indicator: {
                    _icon: {
                        width: "5";
                        height: "5";
                    };
                };
            };
        };
    }>;
    slider: import("..").SlotRecipeDefinition<"root" | "control" | "label" | "valueText" | "thumb" | "track" | "range" | "markerGroup" | "marker" | "draggingIndicator" | "markerIndicator", {
        size: {
            sm: {
                root: {
                    "--slider-thumb-size": "sizes.4";
                    "--slider-track-size": "sizes.1.5";
                    "--slider-marker-center": "6px";
                    "--slider-marker-size": "sizes.1";
                    "--slider-marker-inset": "3px";
                };
            };
            md: {
                root: {
                    "--slider-thumb-size": "sizes.5";
                    "--slider-track-size": "sizes.2";
                    "--slider-marker-center": "8px";
                    "--slider-marker-size": "sizes.1";
                    "--slider-marker-inset": "4px";
                };
            };
            lg: {
                root: {
                    "--slider-thumb-size": "sizes.6";
                    "--slider-track-size": "sizes.2.5";
                    "--slider-marker-center": "9px";
                    "--slider-marker-size": "sizes.1.5";
                    "--slider-marker-inset": "5px";
                };
            };
        };
        variant: {
            outline: {
                track: {
                    shadow: "inset";
                    bg: "bg.emphasized/72";
                };
                range: {
                    bg: "colorPalette.solid";
                };
                thumb: {
                    borderWidth: "2px";
                    borderColor: "colorPalette.solid";
                    bg: "bg";
                    _disabled: {
                        bg: "border.emphasized";
                        borderColor: "border.emphasized";
                    };
                };
            };
            solid: {
                track: {
                    bg: "colorPalette.subtle";
                    _disabled: {
                        bg: "bg.muted";
                    };
                };
                range: {
                    bg: "colorPalette.solid";
                };
                thumb: {
                    bg: "colorPalette.solid";
                    _disabled: {
                        bg: "border.emphasized";
                    };
                };
            };
        };
        orientation: {
            vertical: {
                root: {
                    display: "inline-flex";
                };
                control: {
                    flexDirection: "column";
                    height: "100%";
                    minWidth: "var(--slider-thumb-size)";
                    "&[data-has-mark-label], &:has(.chakra-slider__marker-label)": {
                        marginEnd: "4";
                    };
                };
                track: {
                    width: "var(--slider-track-size)";
                };
                thumb: {
                    left: "50%";
                    translate: "-50% 0";
                };
                markerGroup: {
                    insetStart: "var(--slider-marker-center)";
                    insetBlock: "var(--slider-marker-inset)";
                };
                marker: {
                    flexDirection: "row";
                };
            };
            horizontal: {
                control: {
                    flexDirection: "row";
                    width: "100%";
                    minHeight: "var(--slider-thumb-size)";
                    "&[data-has-mark-label], &:has(.chakra-slider__marker-label)": {
                        marginBottom: "4";
                    };
                };
                track: {
                    height: "var(--slider-track-size)";
                };
                thumb: {
                    top: "50%";
                    translate: "0 -50%";
                };
                markerGroup: {
                    top: "var(--slider-marker-center)";
                    insetInline: "var(--slider-marker-inset)";
                };
                marker: {
                    flexDirection: "column";
                };
            };
        };
    }>;
    stat: import("..").SlotRecipeDefinition<"root" | "indicator" | "label" | "valueText" | "helpText" | "valueUnit", {
        size: {
            sm: {
                valueText: {
                    textStyle: "xl";
                };
            };
            md: {
                valueText: {
                    textStyle: "2xl";
                };
            };
            lg: {
                valueText: {
                    textStyle: "3xl";
                };
            };
        };
    }>;
    steps: import("..").SlotRecipeDefinition<"root" | "item" | "content" | "separator" | "title" | "description" | "indicator" | "list" | "trigger" | "nextTrigger" | "prevTrigger" | "progress", {
        orientation: {
            vertical: {
                root: {
                    flexDirection: "row";
                    height: "100%";
                };
                list: {
                    flexDirection: "column";
                    alignItems: "flex-start";
                };
                separator: {
                    position: "absolute";
                    width: "var(--steps-thickness)";
                    height: "100%";
                    maxHeight: "calc(100% - var(--steps-size) - var(--steps-gutter) * 2)";
                    top: "calc(var(--steps-size) + var(--steps-gutter))";
                    insetStart: "calc(var(--steps-size) / 2 - 1px)";
                };
                item: {
                    alignItems: "flex-start";
                };
            };
            horizontal: {
                root: {
                    flexDirection: "column";
                    width: "100%";
                };
                list: {
                    flexDirection: "row";
                    alignItems: "center";
                };
                separator: {
                    width: "100%";
                    height: "var(--steps-thickness)";
                    marginX: "var(--steps-gutter)";
                };
                item: {
                    alignItems: "center";
                };
            };
        };
        variant: {
            solid: {
                indicator: {
                    _incomplete: {
                        borderWidth: "var(--steps-thickness)";
                    };
                    _current: {
                        bg: "colorPalette.muted";
                        borderWidth: "var(--steps-thickness)";
                        borderColor: "colorPalette.solid";
                        color: "colorPalette.fg";
                    };
                    _complete: {
                        bg: "colorPalette.solid";
                        borderColor: "colorPalette.solid";
                        color: "colorPalette.contrast";
                    };
                };
                separator: {
                    _complete: {
                        bg: "colorPalette.solid";
                    };
                };
            };
            subtle: {
                indicator: {
                    _incomplete: {
                        bg: "bg.muted";
                    };
                    _current: {
                        bg: "colorPalette.muted";
                        color: "colorPalette.fg";
                    };
                    _complete: {
                        bg: "colorPalette.emphasized";
                        color: "colorPalette.fg";
                    };
                };
                separator: {
                    _complete: {
                        bg: "colorPalette.emphasized";
                    };
                };
            };
        };
        size: {
            xs: {
                root: {
                    gap: "2.5";
                };
                list: {
                    "--steps-size": "sizes.6";
                    "--steps-icon-size": "sizes.3.5";
                    textStyle: "xs";
                };
                title: {
                    textStyle: "sm";
                };
            };
            sm: {
                root: {
                    gap: "3";
                };
                list: {
                    "--steps-size": "sizes.8";
                    "--steps-icon-size": "sizes.4";
                    textStyle: "xs";
                };
                title: {
                    textStyle: "sm";
                };
            };
            md: {
                root: {
                    gap: "4";
                };
                list: {
                    "--steps-size": "sizes.10";
                    "--steps-icon-size": "sizes.4";
                    textStyle: "sm";
                };
                title: {
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    gap: "6";
                };
                list: {
                    "--steps-size": "sizes.11";
                    "--steps-icon-size": "sizes.5";
                    textStyle: "md";
                };
                title: {
                    textStyle: "md";
                };
            };
        };
    }>;
    switch: import("..").SlotRecipeDefinition<"root" | "indicator" | "control" | "label" | "thumb", {
        variant: {
            solid: {
                control: {
                    borderRadius: "full";
                    bg: "bg.emphasized";
                    focusVisibleRing: "outside";
                    _checked: {
                        bg: "colorPalette.solid";
                    };
                };
                thumb: {
                    bg: "white";
                    width: "var(--switch-height)";
                    height: "var(--switch-height)";
                    scale: "0.8";
                    boxShadow: "sm";
                    _checked: {
                        bg: "colorPalette.contrast";
                    };
                };
            };
            raised: {
                control: {
                    borderRadius: "full";
                    height: "calc(var(--switch-height) / 2)";
                    bg: "bg.muted";
                    boxShadow: "inset";
                    _checked: {
                        bg: "colorPalette.solid/60";
                    };
                };
                thumb: {
                    width: "var(--switch-height)";
                    height: "var(--switch-height)";
                    position: "relative";
                    top: "calc(var(--switch-height) * -0.25)";
                    bg: "white";
                    boxShadow: "xs";
                    focusVisibleRing: "outside";
                    _checked: {
                        bg: "colorPalette.solid";
                    };
                };
            };
        };
        size: {
            xs: {
                root: {
                    "--switch-width": "sizes.6";
                    "--switch-height": "sizes.3";
                    "--switch-indicator-font-size": "fontSizes.xs";
                };
            };
            sm: {
                root: {
                    "--switch-width": "sizes.8";
                    "--switch-height": "sizes.4";
                    "--switch-indicator-font-size": "fontSizes.xs";
                };
            };
            md: {
                root: {
                    "--switch-width": "sizes.10";
                    "--switch-height": "sizes.5";
                    "--switch-indicator-font-size": "fontSizes.sm";
                };
            };
            lg: {
                root: {
                    "--switch-width": "sizes.12";
                    "--switch-height": "sizes.6";
                    "--switch-indicator-font-size": "fontSizes.md";
                };
            };
        };
    }>;
    table: import("..").SlotRecipeDefinition<"root" | "caption" | "header" | "body" | "footer" | "row" | "columnHeader" | "cell", {
        interactive: {
            true: {
                body: {
                    "& tr": {
                        _hover: {
                            bg: "colorPalette.subtle";
                        };
                    };
                };
            };
        };
        stickyHeader: {
            true: {
                header: {
                    "& :where(tr)": {
                        top: "var(--table-sticky-offset, 0)";
                        position: "sticky";
                        zIndex: number;
                    };
                };
            };
        };
        striped: {
            true: {
                row: {
                    "&:nth-of-type(odd) td": {
                        bg: "bg.muted";
                    };
                };
            };
        };
        showColumnBorder: {
            true: {
                columnHeader: {
                    "&:not(:last-of-type)": {
                        borderInlineEndWidth: "1px";
                    };
                };
                cell: {
                    "&:not(:last-of-type)": {
                        borderInlineEndWidth: "1px";
                    };
                };
            };
        };
        variant: {
            line: {
                columnHeader: {
                    borderBottomWidth: "1px";
                };
                cell: {
                    borderBottomWidth: "1px";
                };
                row: {
                    bg: "bg";
                };
            };
            outline: {
                root: {
                    boxShadow: "0 0 0 1px {colors.border}";
                    overflow: "hidden";
                };
                columnHeader: {
                    borderBottomWidth: "1px";
                };
                header: {
                    bg: "bg.muted";
                };
                row: {
                    "&:not(:last-of-type)": {
                        borderBottomWidth: "1px";
                    };
                };
                footer: {
                    borderTopWidth: "1px";
                };
            };
        };
        size: {
            sm: {
                root: {
                    textStyle: "sm";
                };
                columnHeader: {
                    px: "2";
                    py: "2";
                };
                cell: {
                    px: "2";
                    py: "2";
                };
            };
            md: {
                root: {
                    textStyle: "sm";
                };
                columnHeader: {
                    px: "3";
                    py: "3";
                };
                cell: {
                    px: "3";
                    py: "3";
                };
            };
            lg: {
                root: {
                    textStyle: "md";
                };
                columnHeader: {
                    px: "4";
                    py: "3";
                };
                cell: {
                    px: "4";
                    py: "3";
                };
            };
        };
    }>;
    tabs: import("..").SlotRecipeDefinition<"root" | "content" | "indicator" | "list" | "trigger" | "contentGroup", {
        fitted: {
            true: {
                list: {
                    display: "flex";
                };
                trigger: {
                    flex: number;
                    textAlign: "center";
                    justifyContent: "center";
                };
            };
        };
        justify: {
            start: {
                list: {
                    justifyContent: "flex-start";
                };
            };
            center: {
                list: {
                    justifyContent: "center";
                };
            };
            end: {
                list: {
                    justifyContent: "flex-end";
                };
            };
        };
        size: {
            sm: {
                root: {
                    "--tabs-height": "sizes.9";
                    "--tabs-content-padding": "spacing.3";
                };
                trigger: {
                    py: "1";
                    px: "3";
                    textStyle: "sm";
                };
            };
            md: {
                root: {
                    "--tabs-height": "sizes.10";
                    "--tabs-content-padding": "spacing.4";
                };
                trigger: {
                    py: "2";
                    px: "4";
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    "--tabs-height": "sizes.11";
                    "--tabs-content-padding": "spacing.4.5";
                };
                trigger: {
                    py: "2";
                    px: "4.5";
                    textStyle: "md";
                };
            };
        };
        variant: {
            line: {
                list: {
                    display: "flex";
                    borderColor: "border";
                    _horizontal: {
                        borderBottomWidth: "1px";
                    };
                    _vertical: {
                        borderEndWidth: "1px";
                    };
                };
                trigger: {
                    color: "fg.muted";
                    _disabled: {
                        _active: {
                            bg: "initial";
                        };
                    };
                    _selected: {
                        color: "fg";
                        _horizontal: {
                            layerStyle: "indicator.bottom";
                            "--indicator-offset-y": "-1px";
                            "--indicator-color": "colors.colorPalette.solid";
                        };
                        _vertical: {
                            layerStyle: "indicator.end";
                            "--indicator-offset-x": "-1px";
                        };
                    };
                };
            };
            subtle: {
                trigger: {
                    borderRadius: "var(--tabs-trigger-radius)";
                    color: "fg.muted";
                    _selected: {
                        bg: "colorPalette.subtle";
                        color: "colorPalette.fg";
                    };
                };
            };
            enclosed: {
                list: {
                    bg: "bg.muted";
                    padding: "1";
                    borderRadius: "l3";
                    minH: "calc(var(--tabs-height) - 4px)";
                };
                trigger: {
                    justifyContent: "center";
                    color: "fg.muted";
                    borderRadius: "var(--tabs-trigger-radius)";
                    _selected: {
                        bg: "bg";
                        color: "colorPalette.fg";
                        shadow: "xs";
                    };
                };
            };
            outline: {
                list: {
                    "--line-thickness": "1px";
                    "--line-offset": "calc(var(--line-thickness) * -1)";
                    borderColor: "border";
                    display: "flex";
                    _horizontal: {
                        _before: {
                            content: "\"\"";
                            position: "absolute";
                            bottom: "0px";
                            width: "100%";
                            borderBottomWidth: "var(--line-thickness)";
                            borderBottomColor: "border";
                        };
                    };
                    _vertical: {
                        _before: {
                            content: "\"\"";
                            position: "absolute";
                            insetInline: "var(--line-offset)";
                            height: "calc(100% - calc(var(--line-thickness) * 2))";
                            borderEndWidth: "var(--line-thickness)";
                            borderEndColor: "border";
                        };
                    };
                };
                trigger: {
                    color: "fg.muted";
                    borderWidth: "1px";
                    borderColor: "transparent";
                    _selected: {
                        bg: "currentBg";
                        color: "colorPalette.fg";
                    };
                    _horizontal: {
                        borderTopRadius: "var(--tabs-trigger-radius)";
                        marginBottom: "var(--line-offset)";
                        marginEnd: {
                            _notLast: "var(--line-offset)";
                        };
                        _selected: {
                            borderColor: "border";
                            borderBottomColor: "transparent";
                        };
                    };
                    _vertical: {
                        borderStartRadius: "var(--tabs-trigger-radius)";
                        marginEnd: "var(--line-offset)";
                        marginBottom: {
                            _notLast: "var(--line-offset)";
                        };
                        _selected: {
                            borderColor: "border";
                            borderEndColor: "transparent";
                        };
                    };
                };
            };
            plain: {
                trigger: {
                    color: "fg.muted";
                    _selected: {
                        color: "colorPalette.fg";
                    };
                    borderRadius: "var(--tabs-trigger-radius)";
                    "&[data-selected][data-ssr]": {
                        bg: "var(--tabs-indicator-bg)";
                        shadow: "var(--tabs-indicator-shadow)";
                        borderRadius: "var(--tabs-indicator-radius)";
                    };
                };
            };
        };
    }>;
    tag: import("..").SlotRecipeDefinition<"root" | "closeTrigger" | "label" | "startElement" | "endElement", {
        size: {
            sm: {
                root: {
                    px: "1.5";
                    minH: "4.5";
                    gap: "1";
                    "--tag-avatar-size": "spacing.3";
                    "--tag-element-size": "spacing.3";
                    "--tag-element-offset": "-2px";
                };
                label: {
                    textStyle: "xs";
                };
            };
            md: {
                root: {
                    px: "1.5";
                    minH: "5";
                    gap: "1";
                    "--tag-avatar-size": "spacing.3.5";
                    "--tag-element-size": "spacing.3.5";
                    "--tag-element-offset": "-2px";
                };
                label: {
                    textStyle: "xs";
                };
            };
            lg: {
                root: {
                    px: "2";
                    minH: "6";
                    gap: "1.5";
                    "--tag-avatar-size": "spacing.4.5";
                    "--tag-element-size": "spacing.4";
                    "--tag-element-offset": "-3px";
                };
                label: {
                    textStyle: "sm";
                };
            };
            xl: {
                root: {
                    px: "2.5";
                    minH: "8";
                    gap: "1.5";
                    "--tag-avatar-size": "spacing.6";
                    "--tag-element-size": "spacing.4.5";
                    "--tag-element-offset": "-4px";
                };
                label: {
                    textStyle: "sm";
                };
            };
        };
        variant: {
            subtle: {
                root: {
                    bg: "colorPalette.subtle";
                    color: "colorPalette.fg";
                } | undefined;
            };
            solid: {
                root: {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                } | undefined;
            };
            outline: {
                root: {
                    color: "colorPalette.fg";
                    shadow: "inset 0 0 0px 1px var(--shadow-color)";
                    shadowColor: "colorPalette.muted";
                } | undefined;
            };
            surface: {
                root: {
                    bg: "colorPalette.subtle";
                    color: "colorPalette.fg";
                    shadow: "inset 0 0 0px 1px var(--shadow-color)";
                    shadowColor: "colorPalette.muted";
                } | undefined;
            };
        };
    }>;
    toast: import("..").SlotRecipeDefinition<"root" | "closeTrigger" | "title" | "description" | "indicator" | "actionTrigger", import("..").SlotRecipeVariantRecord<"root" | "closeTrigger" | "title" | "description" | "indicator" | "actionTrigger">>;
    tooltip: import("..").SlotRecipeDefinition<"positioner" | "content" | "trigger" | "arrow" | "arrowTip", import("..").SlotRecipeVariantRecord<"positioner" | "content" | "trigger" | "arrow" | "arrowTip">>;
    status: import("..").SlotRecipeDefinition<"root" | "indicator", {
        size: {
            sm: {
                root: {
                    textStyle: "xs";
                };
            };
            md: {
                root: {
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    textStyle: "md";
                };
            };
        };
    }>;
    timeline: import("..").SlotRecipeDefinition<"root" | "item" | "content" | "separator" | "title" | "description" | "indicator" | "connector", {
        variant: {
            subtle: {
                indicator: {
                    bg: "colorPalette.muted";
                };
            };
            solid: {
                indicator: {
                    bg: "colorPalette.solid";
                    color: "colorPalette.contrast";
                };
            };
            outline: {
                indicator: {
                    bg: "currentBg";
                    borderWidth: "1px";
                    borderColor: "colorPalette.muted";
                };
            };
            plain: {};
        };
        size: {
            sm: {
                root: {
                    "--timeline-indicator-size": "sizes.4";
                    "--timeline-font-size": "fontSizes.2xs";
                };
                title: {
                    textStyle: "xs";
                };
            };
            md: {
                root: {
                    "--timeline-indicator-size": "sizes.5";
                    "--timeline-font-size": "fontSizes.xs";
                };
                title: {
                    textStyle: "sm";
                };
            };
            lg: {
                root: {
                    "--timeline-indicator-size": "sizes.6";
                    "--timeline-font-size": "fontSizes.xs";
                };
                title: {
                    mt: "0.5";
                    textStyle: "sm";
                };
            };
            xl: {
                root: {
                    "--timeline-indicator-size": "sizes.8";
                    "--timeline-font-size": "fontSizes.sm";
                };
                title: {
                    mt: "1.5";
                    textStyle: "sm";
                };
            };
        };
    }>;
    colorPicker: import("..").SlotRecipeDefinition<"root" | "positioner" | "content" | "control" | "label" | "trigger" | "area" | "valueText" | "view" | "formatSelect" | "areaThumb" | "channelInput" | "channelSliderTrack" | "channelSliderThumb" | "areaBackground" | "channelSlider" | "channelSliderLabel" | "channelSliderValueText" | "transparencyGrid" | "swatchGroup" | "swatchTrigger" | "swatchIndicator" | "swatch" | "eyeDropperTrigger" | "formatTrigger" | "channelText", {
        size: {
            "2xs": {
                channelInput: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.7";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.4.5";
                };
                trigger: {
                    "--input-height": "sizes.7";
                };
                area: {
                    "--thumb-size": "sizes.3";
                };
                channelSlider: {
                    "--slider-height": "sizes.3";
                    "--thumb-size": "sizes.3";
                };
            };
            xs: {
                channelInput: {
                    textStyle: "xs";
                    px: "2";
                    "--input-height": "sizes.8";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.5";
                };
                trigger: {
                    "--input-height": "sizes.8";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
            sm: {
                channelInput: {
                    textStyle: "sm";
                    px: "2.5";
                    "--input-height": "sizes.9";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.6";
                };
                trigger: {
                    "--input-height": "sizes.9";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
            md: {
                channelInput: {
                    textStyle: "sm";
                    px: "3";
                    "--input-height": "sizes.10";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.7";
                };
                trigger: {
                    "--input-height": "sizes.10";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
            lg: {
                channelInput: {
                    textStyle: "md";
                    px: "4";
                    "--input-height": "sizes.11";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.7";
                };
                trigger: {
                    "--input-height": "sizes.11";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
            xl: {
                channelInput: {
                    textStyle: "md";
                    px: "4.5";
                    "--input-height": "sizes.12";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.8";
                };
                trigger: {
                    "--input-height": "sizes.12";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
            "2xl": {
                channelInput: {
                    textStyle: "lg";
                    px: "5";
                    "--input-height": "sizes.16";
                } | undefined;
                swatch: {
                    "--swatch-size": "sizes.10";
                };
                trigger: {
                    "--input-height": "sizes.16";
                };
                area: {
                    "--thumb-size": "sizes.3.5";
                };
                channelSlider: {
                    "--slider-height": "sizes.3.5";
                    "--thumb-size": "sizes.3.5";
                };
            };
        };
        variant: {
            outline: {
                channelInput: {
                    bg: "transparent";
                    borderWidth: "1px";
                    borderColor: "border";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | undefined;
                trigger: {
                    borderWidth: "1px";
                };
            };
            subtle: {
                channelInput: {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                    focusVisibleRing: "inside";
                    focusRingColor: "var(--focus-color)";
                } | undefined;
                trigger: {
                    borderWidth: "1px";
                    borderColor: "transparent";
                    bg: "bg.muted";
                };
            };
        };
    }>;
    qrCode: import("..").SlotRecipeDefinition<"root" | "overlay" | "pattern" | "frame" | "downloadTrigger", {
        size: {
            "2xs": {
                root: {
                    "--qr-code-size": "40px";
                };
            };
            xs: {
                root: {
                    "--qr-code-size": "64px";
                };
            };
            sm: {
                root: {
                    "--qr-code-size": "80px";
                };
            };
            md: {
                root: {
                    "--qr-code-size": "120px";
                };
            };
            lg: {
                root: {
                    "--qr-code-size": "160px";
                };
            };
            xl: {
                root: {
                    "--qr-code-size": "200px";
                };
            };
            "2xl": {
                root: {
                    "--qr-code-size": "240px";
                };
            };
            full: {
                root: {
                    "--qr-code-size": "100%";
                };
            };
        };
    }>;
};
