import type { Assign } from "@ark-ui/react";
import { RatingGroup as ArkRatingGroup } from "@ark-ui/react/rating-group";
import { type HTMLChakraProps, type SlotRecipeProps, type UnstyledProp } from "../../styled-system";
declare const useRatingGroupStyles: () => Record<string, import("../..").SystemStyleObject>;
export { useRatingGroupStyles };
export interface RatingGroupRootProviderBaseProps extends Assign<ArkRatingGroup.RootProviderBaseProps, SlotRecipeProps<"ratingGroup">>, UnstyledProp {
}
export interface RatingGroupRootProviderProps extends HTMLChakraProps<"div", RatingGroupRootProviderBaseProps> {
}
export declare const RatingGroupRootProvider: import("react").ForwardRefExoticComponent<RatingGroupRootProviderProps & import("react").RefAttributes<HTMLDivElement>>;
export interface RatingGroupRootBaseProps extends Assign<ArkRatingGroup.RootBaseProps, SlotRecipeProps<"ratingGroup">>, UnstyledProp {
}
export interface RatingGroupRootProps extends HTMLChakraProps<"div", RatingGroupRootBaseProps> {
}
export declare const RatingGroupRoot: import("react").ForwardRefExoticComponent<RatingGroupRootProps & import("react").RefAttributes<HTMLDivElement>>;
export declare const RatingGroupPropsProvider: React.Provider<RatingGroupRootBaseProps>;
export interface RatingGroupLabelProps extends HTMLChakraProps<"div", ArkRatingGroup.LabelBaseProps> {
}
export declare const RatingGroupLabel: import("react").ForwardRefExoticComponent<RatingGroupLabelProps & import("react").RefAttributes<HTMLDivElement>>;
export interface RatingGroupItemProps extends HTMLChakraProps<"div", ArkRatingGroup.ItemBaseProps> {
}
export declare const RatingGroupItem: import("react").ForwardRefExoticComponent<RatingGroupItemProps & import("react").RefAttributes<HTMLDivElement>>;
export interface RatingGroupItemIndicatorProps extends HTMLChakraProps<"span"> {
    icon?: React.ReactElement;
}
export declare const RatingGroupItemIndicator: import("react").ForwardRefExoticComponent<RatingGroupItemIndicatorProps & import("react").RefAttributes<HTMLSpanElement>>;
export interface RatingGroupItemsProps extends Omit<RatingGroupItemProps, "index"> {
}
export declare const RatingGroupItems: (props: RatingGroupItemsProps) => import("react/jsx-runtime").JSX.Element;
export interface RatingGroupControlProps extends HTMLChakraProps<"div", ArkRatingGroup.ControlBaseProps> {
}
export declare const RatingGroupControl: import("react").ForwardRefExoticComponent<RatingGroupControlProps & import("react").RefAttributes<HTMLDivElement>>;
export declare const RatingGroupContext: (props: ArkRatingGroup.ContextProps) => import("react").ReactNode;
export declare const RatingGroupItemContext: (props: ArkRatingGroup.ItemContextProps) => import("react").ReactNode;
export declare const RatingGroupHiddenInput: import("react").ForwardRefExoticComponent<ArkRatingGroup.HiddenInputProps & import("react").RefAttributes<HTMLInputElement>>;
export interface RatingGroupValueChangeDetails extends ArkRatingGroup.ValueChangeDetails {
}
export interface RatingGroupHoverChangeDetails extends ArkRatingGroup.HoverChangeDetails {
}
