'use client';
import { jsx } from 'react/jsx-runtime';
import { mergeProps } from '@zag-js/react';
import { forwardRef } from 'react';
import { composeRefs } from '../../utils/compose-refs.js';
import { ark } from '../factory.js';
import { usePresenceContext } from '../presence/use-presence-context.js';
import { useTourContext } from './use-tour-context.js';

const TourContent = forwardRef((props, ref) => {
  const tour = useTourContext();
  const presence = usePresenceContext();
  const mergedProps = mergeProps(tour.getContentProps(), presence.getPresenceProps(), props);
  if (presence.unmounted) {
    return null;
  }
  return /* @__PURE__ */ jsx(ark.div, { ...mergedProps, ref: composeRefs(presence.ref, ref) });
});
TourContent.displayName = "TourContent";

export { TourContent };
