'use client';
import { jsx } from 'react/jsx-runtime';
import { mergeProps } from '@zag-js/react';
import { forwardRef } from 'react';
import { composeRefs } from '../../utils/compose-refs.js';
import { ark } from '../factory.js';
import { usePresenceContext } from '../presence/use-presence-context.js';
import { useTooltipContext } from './use-tooltip-context.js';

const TooltipContent = forwardRef((props, ref) => {
  const tooltip = useTooltipContext();
  const presence = usePresenceContext();
  const mergedProps = mergeProps(tooltip.getContentProps(), presence.getPresenceProps(), props);
  if (presence.unmounted) {
    return null;
  }
  return /* @__PURE__ */ jsx(ark.div, { ...mergedProps, ref: composeRefs(presence.ref, ref) });
});
TooltipContent.displayName = "TooltipContent";

export { TooltipContent };
