'use client';
'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const react$1 = require('@zag-js/react');
const react = require('react');
const factory = require('../factory.cjs');
const usePresenceContext = require('../presence/use-presence-context.cjs');
const useHoverCardContext = require('./use-hover-card-context.cjs');

const HoverCardPositioner = react.forwardRef((props, ref) => {
  const hoverCard = useHoverCardContext.useHoverCardContext();
  const mergedProps = react$1.mergeProps(hoverCard.getPositionerProps(), props);
  const presence = usePresenceContext.usePresenceContext();
  if (presence.unmounted) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(factory.ark.div, { ...mergedProps, ref });
});
HoverCardPositioner.displayName = "HoverCardPositioner";

exports.HoverCardPositioner = HoverCardPositioner;
