'use client';
import { jsx } from 'react/jsx-runtime';
import { mergeProps } from '@zag-js/react';
import { forwardRef } from 'react';
import { ark } from '../factory.js';
import { useEditableContext } from './use-editable-context.js';

const EditableControl = forwardRef((props, ref) => {
  const editable = useEditableContext();
  const mergedProps = mergeProps(editable.getControlProps(), props);
  return /* @__PURE__ */ jsx(ark.div, { ...mergedProps, ref });
});
EditableControl.displayName = "EditableControl";

export { EditableControl };
